/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.block.BlockBookshelf;
import knightminer.inspirations.shared.client.TextureModel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BookshelfModel
extends TextureModel {
    public static final Cache<BookshelfCacheKey, IBakedModel> BOOK_CACHE = CacheBuilder.newBuilder().maximumSize(30L).build();

    public BookshelfModel(IBakedModel standard, IModel model, VertexFormat format) {
        super(standard, model, format, "texture", true);
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        IBakedModel bakedModel = this.originalModel;
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            String texture = (String)extendedState.getValue((IUnlistedProperty)BlockBookshelf.TEXTURE);
            Integer booksValue = (Integer)extendedState.getValue(BlockBookshelf.BOOKS);
            int books = booksValue != null ? booksValue : 0;
            try {
                bakedModel = (IBakedModel)BOOK_CACHE.get((Object)new BookshelfCacheKey(extendedState.getClean(), texture, books), () -> {
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    if (texture != null) {
                        builder.put((Object)"texture", (Object)texture);
                    }
                    for (int i = 0; i < 14; ++i) {
                        if ((books & 1 << i) != 0) continue;
                        builder.put((Object)("#book" + i), (Object)"");
                        builder.put((Object)("#bookLabel" + i), (Object)"");
                    }
                    return this.getTexturedModel((ImmutableMap<String, String>)builder.build());
                });
            }
            catch (ExecutionException e) {
                Inspirations.log.error((Object)e);
            }
        }
        return bakedModel.func_188616_a(state, side, rand);
    }

    private static class BookshelfCacheKey {
        private IBlockState state;
        @Nullable
        private String texture;
        private int books;

        public BookshelfCacheKey(IBlockState state, @Nullable String texture, int books) {
            this.state = state;
            this.texture = texture;
            this.books = books;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BookshelfCacheKey that = (BookshelfCacheKey)o;
            return this.books == that.books && this.state == that.state && (this.texture == that.texture || this.texture != null && this.texture.equals(that.texture));
        }

        public int hashCode() {
            return 31 * (31 * this.state.hashCode() + (this.texture == null ? 0 : this.texture.hashCode())) + this.books;
        }
    }
}

