/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.tileentity;

import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.utility.client.GuiPipe;
import knightminer.inspirations.utility.inventory.ContainerPipe;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.mantle.tileentity.TileInventory;

public class TilePipe
extends TileInventory
implements IInventoryGui,
ITickable {
    private short cooldown = 0;
    private static final String TAG_COOLDOWN = "cooldown";

    public TilePipe() {
        super("gui.inspirations.pipe.name", 1);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_73660_a() {
        IItemHandler neighbor;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        EnumFacing facing = this.getFacing();
        if (!Config.pipeUpwards && facing == EnumFacing.UP) {
            return;
        }
        this.cooldown = (short)(this.cooldown - 1);
        if (this.cooldown > 0) {
            return;
        }
        this.cooldown = 0;
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_190926_b()) {
            return;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (te != null && (neighbor = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) != null) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)neighbor, (ItemStack)copy, (boolean)false).func_190926_b()) {
                if (te instanceof TileEntityHopper) {
                    ((TileEntityHopper)te).func_145896_c(7);
                }
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    this.func_70299_a(0, ItemStack.field_190927_a);
                }
                this.cooldown = (short)8;
                this.func_70296_d();
            }
        }
    }

    public void func_70299_a(int slot, @Nonnull ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        this.cooldown = (short)7;
    }

    private EnumFacing getFacing() {
        return EnumFacing.func_82600_a((int)(this.func_145832_p() & 7));
    }

    public ContainerPipe createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerPipe(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiPipe(this.createContainer(inventoryplayer, world, pos));
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.getTileData().func_74737_b();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.cooldown = tags.func_74765_d(TAG_COOLDOWN);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        tags.func_74777_a(TAG_COOLDOWN, this.cooldown);
        return tags;
    }
}

