/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.machines;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.BlockWorldState;
import gregtech.api.multiblock.IPatternCenterPredicate;
import gregtech.api.multiblock.PatternMatchContext;
import gregtech.api.util.IntRange;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SingleLimitBlockPattern
extends BlockPattern {
    private Predicate<BlockWorldState>[] predicatesCheckLayers;
    private int[] centerOffset = null;
    private final Predicate<BlockWorldState>[][][] blockMatches;
    private final BlockPattern.RelativeDirection[] structureDir;
    private final int[][] aisleRepetitions;

    public SingleLimitBlockPattern(Predicate<BlockWorldState>[][][] predicatesIn, List<Pair<Predicate<BlockWorldState>, IntRange>> countMatches, BlockPattern.RelativeDirection[] structureDir, int[][] aisleRepetitions, Predicate<BlockWorldState>[] predicatesCheckLayers) {
        super((Predicate[][][])predicatesIn, countMatches, (TIntObjectMap)new TIntObjectHashMap(), new ArrayList(), structureDir, aisleRepetitions);
        this.predicatesCheckLayers = predicatesCheckLayers;
        this.blockMatches = predicatesIn;
        this.aisleRepetitions = aisleRepetitions;
        this.structureDir = structureDir;
        this.initializeCenterOffsets();
    }

    private void initializeCenterOffsets() {
        block0: for (int x = 0; x < this.getPalmLength(); ++x) {
            for (int y = 0; y < this.getThumbLength(); ++y) {
                int minZ = 0;
                int maxZ = 0;
                for (int z = 0; z < this.getFingerLength(); ++z) {
                    Predicate<BlockWorldState> predicate = this.blockMatches[z][y][x];
                    if (predicate instanceof IPatternCenterPredicate) {
                        this.centerOffset = new int[]{x, y, z, minZ, maxZ};
                        break block0;
                    }
                    minZ += this.aisleRepetitions[z][0];
                    maxZ += this.aisleRepetitions[z][1];
                }
            }
        }
        if (this.centerOffset == null) {
            throw new IllegalArgumentException("Didn't found center predicate");
        }
    }

    public PatternMatchContext checkPatternAt(World world, BlockPos centerPos, EnumFacing facing) {
        BlockWorldState worldState = new BlockWorldState();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        PatternMatchContext matchContext = new PatternMatchContext();
        boolean findFirstAisle = false;
        int minZ = -this.centerOffset[4];
        int z = minZ++;
        for (int c = 0; c < this.getFingerLength(); ++c) {
            int r = 0;
            while (findFirstAisle ? r < this.aisleRepetitions[c][1] : z <= -this.centerOffset[3]) {
                block13: {
                    boolean hasBlock = false;
                    int b = 0;
                    int y = -this.centerOffset[1];
                    while (b < this.getThumbLength()) {
                        int a = 0;
                        int x = -this.centerOffset[0];
                        while (a < this.getPalmLength()) {
                            Predicate<BlockWorldState> predicate = this.blockMatches[c][b][a];
                            this.setActualRelativeOffset(blockPos, x, y, z, facing);
                            blockPos.func_181079_c(blockPos.func_177958_n() + centerPos.func_177958_n(), blockPos.func_177956_o() + centerPos.func_177956_o(), blockPos.func_177952_p() + centerPos.func_177952_p());
                            worldState.update(world, (BlockPos)blockPos, matchContext, new PatternMatchContext());
                            if (this.predicatesCheckLayers != null && this.predicatesCheckLayers[c] != null) {
                                if (hasBlock && this.predicatesCheckLayers[c].test(worldState)) {
                                    return null;
                                }
                                if (!hasBlock && this.predicatesCheckLayers[c].test(worldState)) {
                                    hasBlock = true;
                                }
                            } else {
                                hasBlock = true;
                            }
                            if (!predicate.test(worldState)) {
                                if (findFirstAisle) {
                                    if (r < this.aisleRepetitions[c][0]) {
                                        c = 0;
                                        r = 0;
                                        z = minZ++;
                                        matchContext.reset();
                                        findFirstAisle = false;
                                    }
                                } else {
                                    ++z;
                                }
                                break block13;
                            }
                            ++a;
                            ++x;
                        }
                        ++b;
                        ++y;
                    }
                    if (!hasBlock) {
                        return null;
                    }
                    findFirstAisle = true;
                    ++z;
                }
                ++r;
            }
            if (r >= this.aisleRepetitions[c][0]) continue;
            return null;
        }
        return matchContext;
    }

    private BlockPos.MutableBlockPos setActualRelativeOffset(BlockPos.MutableBlockPos pos, int x, int y, int z, EnumFacing facing) {
        if (!ArrayUtils.contains((Object[])EnumFacing.field_176754_o, (Object)facing)) {
            throw new IllegalArgumentException("Can rotate only horizontally");
        }
        int[] c0 = new int[]{x, y, z};
        int[] c1 = new int[3];
        block8: for (int i = 0; i < 3; ++i) {
            switch (this.structureDir[i].getActualFacing(facing)) {
                case UP: {
                    c1[1] = c0[i];
                    continue block8;
                }
                case DOWN: {
                    c1[1] = -c0[i];
                    continue block8;
                }
                case WEST: {
                    c1[0] = -c0[i];
                    continue block8;
                }
                case EAST: {
                    c1[0] = c0[i];
                    continue block8;
                }
                case NORTH: {
                    c1[2] = -c0[i];
                    continue block8;
                }
                case SOUTH: {
                    c1[2] = c0[i];
                }
            }
        }
        return pos.func_181079_c(c1[0], c1[1], c1[2]);
    }
}

