/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.base;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.client.utils.ToolTipUtils;
import com.sofodev.armorplus.common.iface.IModdedItem;
import com.sofodev.armorplus.common.registry.items.base.special.Bows;
import com.sofodev.armorplus.common.util.ArmorPlusItemUtils;
import com.sofodev.armorplus.common.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpecialBow
extends ItemBow
implements IModdedItem {
    public double damage;
    public String itemName;
    public Bows bows;
    private ItemStack itemExpert;
    private Item itemBow;
    private TextFormatting formatting;

    public ItemSpecialBow(Bows bows) {
        this.bows = bows;
        this.itemName = bows.getName();
        this.func_77656_e(bows.getDurability(false));
        this.damage = bows.getDamage();
        this.itemExpert = bows.getRepairStack();
        this.formatting = bows.getTextFormatting();
        this.itemBow = bows.getBowItem();
        this.setRegistryName(Utils.setRL(bows.getName() + "_bow"));
        this.func_77655_b(Utils.setName(bows.getName() + "_bow"));
        this.func_77637_a(ArmorPlus.tabArmorPlusWeapons);
        this.field_77777_bU = 1;
        IItemPropertyGetter pull = (stack, worldIn, entityIn) -> {
            if (entityIn == null) {
                return 0.0f;
            }
            ItemStack itemstack = entityIn.func_184607_cu();
            return itemstack.func_190916_E() > 0 && itemstack.func_77973_b() == this.itemBow ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 5.0f : 0.0f;
        };
        this.func_185043_a(new ResourceLocation("pull"), pull);
        IItemPropertyGetter pulling = (stack, worldIn, entityIn) -> entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
        this.func_185043_a(new ResourceLocation("pulling"), pulling);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        this.initModel(this.bows.getName(), 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add(new TextComponentTranslation("item.armorplus.bow.desc", new Object[]{this.damage}).func_150254_d());
        } else {
            ToolTipUtils.showInfo(tooltip, keyBindSneak, this.formatting);
        }
    }

    @Nonnull
    public IRarity getForgeRarity(ItemStack stack) {
        return this.getRarity(this.formatting, "Bow");
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ArmorPlusItemUtils.isItemRepairable(repair, this.itemExpert);
    }

    public float getVelocityOfArrow(ItemStack stack) {
        Utils.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74764_b("velocity") ? tag.func_74760_g("velocity") : 3.0f;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        float arrowVelocity;
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        boolean requiredConditions = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack itemstack = this.func_185060_a(player);
        int useDuration = this.func_77626_a(stack) - timeLeft;
        if ((useDuration = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)useDuration, (!itemstack.func_190926_b() || requiredConditions ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (itemstack.func_190926_b() && !requiredConditions) {
            return;
        }
        if (itemstack.func_190926_b()) {
            itemstack = new ItemStack(Items.field_151032_g);
        }
        if ((double)(arrowVelocity = ItemSpecialBow.func_185059_b((int)useDuration)) >= 0.1) {
            boolean secondaryConditions = requiredConditions && itemstack.func_77973_b() instanceof ItemArrow;
            this.spawnArrow(world, (EntityLivingBase)player, itemstack, stack, arrowVelocity, secondaryConditions);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
            if (!secondaryConditions) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    player.field_71071_by.func_184437_d(itemstack);
                }
            }
            player.func_71029_a(StatList.func_188057_b((Item)this));
        }
    }

    private void spawnArrow(World world, EntityLivingBase player, ItemStack itemstack, ItemStack stack, float arrowVelocity, boolean secondaryConditions) {
        if (!world.field_72995_K) {
            ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
            EntityArrow entityArrow = itemarrow.func_185052_a(world, itemstack, player);
            float newArrowVelocity = arrowVelocity * this.getVelocityOfArrow(stack);
            entityArrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, newArrowVelocity, 1.0f);
            if (newArrowVelocity == 0.0f) {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 0.4f, 1.0f);
                return;
            }
            int powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            entityArrow.func_70239_b(entityArrow.func_70242_d() + this.damage + (powerLevel > 0 ? (double)powerLevel * 0.5 + 0.5 : 0.0));
            int punchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
            if (punchLevel > 0) {
                entityArrow.func_70240_a(punchLevel);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                entityArrow.func_70015_d(100);
            }
            stack.func_77972_a(1, player);
            if (secondaryConditions) {
                entityArrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            }
            world.func_72838_d((Entity)entityArrow);
        }
    }
}

