/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.util;

import com.sofodev.armorplus.api.properties.AbilityCanceller;
import com.sofodev.armorplus.api.properties.AbilityProvider;
import com.sofodev.armorplus.api.properties.iface.IEffectHolder;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.items.armors.APArmorMaterial;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemSpecialArmor;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemUltimateArmor;
import com.sofodev.armorplus.common.registry.items.base.special.effects.Negative;
import com.sofodev.armorplus.common.util.PotionUtils;
import com.sofodev.armorplus.common.util.Utils;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;

public final class ArmorPlusItemUtils {
    private ArmorPlusItemUtils() {
    }

    public static void createPieces(ItemArmor armor, EntityEquipmentSlot slot, String name) {
        String piece = slot == EntityEquipmentSlot.HEAD ? name + "_helmet" : (slot == EntityEquipmentSlot.CHEST ? name + "_chestplate" : (slot == EntityEquipmentSlot.LEGS ? name + "_leggings" : (slot == EntityEquipmentSlot.FEET ? name + "_boots" : name + "")));
        armor.setRegistryName(Utils.setRL(piece));
        armor.func_77655_b(Utils.setName(piece));
    }

    public static boolean isItemRepairable(ItemStack repair, ItemStack expert) {
        return ModConfig.getRD().isItemRepairable(repair, expert);
    }

    public static boolean isSetMatchingMaterials(EntityLivingBase player, Item head, Item chest, Item legs, Item feet, APArmorMaterial material) {
        return ArmorPlusItemUtils.isEqualMaterial((ItemSpecialArmor)head, material) && ArmorPlusItemUtils.isEqualMaterial((ItemSpecialArmor)chest, material) && ArmorPlusItemUtils.isEqualMaterial((ItemSpecialArmor)legs, material) && ArmorPlusItemUtils.isEqualMaterial((ItemSpecialArmor)feet, material);
    }

    public static boolean isEqualMaterial(ItemSpecialArmor armor, APArmorMaterial material) {
        return armor.field_77878_bZ == material;
    }

    public static boolean areAllBaseInstances(Item head, Item chest, Item legs, Item feet) {
        return head instanceof ItemSpecialArmor && chest instanceof ItemSpecialArmor && legs instanceof ItemSpecialArmor && feet instanceof ItemSpecialArmor;
    }

    public static boolean areAllUltimateInstances(Item head, Item chest, Item legs, Item feet) {
        return head instanceof ItemUltimateArmor && chest instanceof ItemUltimateArmor && legs instanceof ItemUltimateArmor && feet instanceof ItemUltimateArmor;
    }

    public static boolean isFullSet(EntityLivingBase player, Item head, Item chest, Item legs, Item feet) {
        ItemStack feetStack;
        ItemStack legsStack;
        ItemStack chestStack;
        ItemStack headStack = ArmorPlusItemUtils.getHead(player);
        return !ArmorPlusItemUtils.isArmorEmpty(headStack, chestStack = ArmorPlusItemUtils.getChest(player), legsStack = ArmorPlusItemUtils.getLegs(player), feetStack = ArmorPlusItemUtils.getFeet(player)) && ArmorPlusItemUtils.areEqual(headStack, head) && ArmorPlusItemUtils.areEqual(chestStack, chest) && ArmorPlusItemUtils.areEqual(legsStack, legs) && ArmorPlusItemUtils.areEqual(feetStack, feet);
    }

    public static boolean areEqual(ItemStack a, Item b) {
        return a.func_77973_b() == b;
    }

    public static boolean isArmorEmpty(ItemStack helmet, ItemStack chestplate, ItemStack leggings, ItemStack boots) {
        return helmet.func_190926_b() || chestplate.func_190926_b() || leggings.func_190926_b() || boots.func_190926_b();
    }

    public static ItemStack getHead(EntityLivingBase player) {
        return player.func_184582_a(EntityEquipmentSlot.HEAD);
    }

    public static ItemStack getChest(EntityLivingBase player) {
        return player.func_184582_a(EntityEquipmentSlot.CHEST);
    }

    public static ItemStack getLegs(EntityLivingBase player) {
        return player.func_184582_a(EntityEquipmentSlot.LEGS);
    }

    public static ItemStack getFeet(EntityLivingBase player) {
        return player.func_184582_a(EntityEquipmentSlot.FEET);
    }

    public static void applyEffects(EntityLivingBase player, IEffectHolder effectHolder) {
        AbilityProvider applicable = effectHolder.getApplicableAbilities();
        AbilityCanceller removable = effectHolder.getRemovableAbilities();
        ArmorPlusItemUtils.applyEffects(player, Utils.boxList(applicable.getAbilities().name), Utils.boxList(applicable.getAbilities().duration), Utils.boxList(applicable.getAbilities().level), Utils.boxList(removable.getAbilities()));
    }

    public static void applyEffects(EntityLivingBase player, List<String> applyEffectNames, List<Integer> applyEffectDurations, List<Integer> applyEffectLevels, List<String> removableEffects) {
        List potions = applyEffectNames.stream().map(PotionUtils::getPotion).collect(Collectors.toList());
        int bound = potions.size();
        for (int potionID = 0; potionID < bound; ++potionID) {
            if (potions.isEmpty()) {
                return;
            }
            Potion potionEffect2 = (Potion)potions.get(potionID);
            if (player.func_70660_b(potionEffect2) != null && potionEffect2 != MobEffects.field_76439_r) continue;
            int duration = Utils.convertToSeconds(applyEffectDurations.get(potionID));
            int level = applyEffectLevels.get(potionID);
            PotionUtils.addPotion(player, potionEffect2, duration, level, PotionUtils.PotionType.GOOD);
        }
        List removablePotions = removableEffects.stream().map(PotionUtils::getPotion).collect(Collectors.toList());
        removablePotions.stream().filter(potionEffect -> player.func_70660_b(potionEffect) != null).forEach(arg_0 -> ((EntityLivingBase)player).func_184596_c(arg_0));
    }

    public static void applyNegativeEffect(EntityLivingBase target, Negative effect) {
        if (effect.isEnabled()) {
            IntStream.range(0, effect.getEffects().length).forEach(potionID -> {
                Potion negative = PotionUtils.getPotion(effect.getEffects()[potionID]);
                int duration = Utils.convertToSeconds(effect.getEffectDurations()[potionID]);
                int level = effect.getEffectLevels()[potionID];
                PotionUtils.addPotion(target, negative, duration, level, PotionUtils.PotionType.BAD);
            });
        }
    }
}

