/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.client.renderer.sky;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.client.TextureDataObject;
import com.bloodnbonesgaming.topography.client.renderer.sky.SkyRenderObject;
import com.bloodnbonesgaming.topography.client.renderer.sky.SkyboxTextureDataObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/SkyboxRenderer", classExplaination="This file is for the SkyboxRenderer. This is for making a custom skybox using SkyRendererCustom.")
public class SkyboxRenderer
extends SkyRenderObject {
    private final SkyboxTextureDataObject singleTexture;
    private final TextureDataObject topTexture;
    private final TextureDataObject bottomTexture;
    private final TextureDataObject northTexture;
    private final TextureDataObject southTexture;
    private final TextureDataObject eastTexture;
    private final TextureDataObject westTexture;
    private final Map<MinMaxBounds, MinMaxBounds> alphaModifiers = new LinkedHashMap<MinMaxBounds, MinMaxBounds>();

    public SkyboxRenderer(String singleTexture) {
        this.singleTexture = new SkyboxTextureDataObject(new ResourceLocation(singleTexture));
        this.topTexture = null;
        this.bottomTexture = null;
        this.northTexture = null;
        this.southTexture = null;
        this.eastTexture = null;
        this.westTexture = null;
    }

    public SkyboxRenderer(String topTexture, String bottomTexture, String northTexture, String southTexture, String eastTexture, String westTexture) {
        this.topTexture = new TextureDataObject(new ResourceLocation(topTexture));
        this.bottomTexture = new TextureDataObject(new ResourceLocation(bottomTexture));
        this.northTexture = new TextureDataObject(new ResourceLocation(northTexture));
        this.southTexture = new TextureDataObject(new ResourceLocation(southTexture));
        this.eastTexture = new TextureDataObject(new ResourceLocation(eastTexture));
        this.westTexture = new TextureDataObject(new ResourceLocation(westTexture));
        this.singleTexture = null;
    }

    @ScriptMethodDocumentation(args="MinMaxBounds, MinMaxBounds", usage="angle bounds, alpha for transition", notes="Adds paired celestial angle bounds and alpha. Used to create a blended skybox transition as time passes.")
    public void addAlpha(MinMaxBounds angle, MinMaxBounds alpha) {
        this.alphaModifiers.put(angle, alpha);
    }

    @Override
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        if (this.singleTexture != null) {
            this.renderSingleTexture(partialTicks, world, mc);
        } else {
            this.renderSeparateTextures(partialTicks, world, mc);
        }
    }

    public void renderSeparateTextures(float partialTicks, WorldClient world, Minecraft mc) {
        GlStateManager.func_179106_n();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)519, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        float celestialAngle = world.func_72826_c(partialTicks);
        float alpha = 1.0f;
        for (Map.Entry<MinMaxBounds, MinMaxBounds> entry : this.alphaModifiers.entrySet()) {
            if (!entry.getKey().func_192514_a(celestialAngle)) continue;
            MinMaxBounds key = entry.getKey();
            MinMaxBounds value = entry.getValue();
            if (value.field_192517_b == null || value.field_192518_c == null) continue;
            float diff = key.field_192518_c.floatValue() - key.field_192517_b.floatValue();
            float distIntoRange = celestialAngle - key.field_192517_b.floatValue();
            float percent = distIntoRange / diff;
            if (value.field_192517_b.floatValue() > value.field_192518_c.floatValue()) {
                float alphaDiff = value.field_192517_b.floatValue() - value.field_192518_c.floatValue();
                alpha = value.field_192517_b.floatValue() - alphaDiff * percent;
                break;
            }
            float alphaDiff = value.field_192518_c.floatValue() - value.field_192517_b.floatValue();
            alpha = value.field_192517_b.floatValue() + alphaDiff * percent;
            break;
        }
        GlStateManager.func_179114_b((float)(celestialAngle * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        this.bottomTexture.bind();
        double xStartPos = 0 / this.bottomTexture.getWidth();
        double yStartPos = 0 / this.bottomTexture.getHeight();
        double xEndPos = this.bottomTexture.getWidth() / this.bottomTexture.getWidth();
        double yEndPos = this.bottomTexture.getHeight() / this.bottomTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.topTexture.bind();
        xStartPos = 0 / this.topTexture.getWidth();
        yStartPos = 0 / this.topTexture.getHeight();
        xEndPos = this.topTexture.getWidth() / this.topTexture.getWidth();
        yEndPos = this.topTexture.getHeight() / this.topTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.northTexture.bind();
        xStartPos = 0 / this.northTexture.getWidth();
        yStartPos = 0 / this.northTexture.getHeight();
        xEndPos = this.northTexture.getWidth() / this.northTexture.getWidth();
        yEndPos = this.northTexture.getHeight() / this.northTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.southTexture.bind();
        xStartPos = 0 / this.southTexture.getWidth();
        yStartPos = 0 / this.southTexture.getHeight();
        xEndPos = this.southTexture.getWidth() / this.southTexture.getWidth();
        yEndPos = this.southTexture.getHeight() / this.southTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.eastTexture.bind();
        xStartPos = 0 / this.eastTexture.getWidth();
        yStartPos = 0 / this.eastTexture.getHeight();
        xEndPos = this.eastTexture.getWidth() / this.eastTexture.getWidth();
        yEndPos = this.eastTexture.getHeight() / this.eastTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.westTexture.bind();
        xStartPos = 0 / this.westTexture.getWidth();
        yStartPos = 0 / this.westTexture.getHeight();
        xEndPos = this.westTexture.getWidth() / this.westTexture.getWidth();
        yEndPos = this.westTexture.getHeight() / this.westTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.5f);
        GlStateManager.func_179127_m();
        GlStateManager.func_179098_w();
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
    }

    public void renderSingleTexture(float partialTicks, WorldClient world, Minecraft mc) {
        GlStateManager.func_179106_n();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)519, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        float celestialAngle = world.func_72826_c(partialTicks);
        float alpha = 1.0f;
        for (Map.Entry<MinMaxBounds, MinMaxBounds> entry : this.alphaModifiers.entrySet()) {
            if (!entry.getKey().func_192514_a(celestialAngle)) continue;
            MinMaxBounds key = entry.getKey();
            MinMaxBounds value = entry.getValue();
            if (value.field_192517_b == null || value.field_192518_c == null) continue;
            float diff = key.field_192518_c.floatValue() - key.field_192517_b.floatValue();
            float distIntoRange = celestialAngle - key.field_192517_b.floatValue();
            float percent = distIntoRange / diff;
            if (value.field_192517_b.floatValue() > value.field_192518_c.floatValue()) {
                float alphaDiff = value.field_192517_b.floatValue() - value.field_192518_c.floatValue();
                alpha = value.field_192517_b.floatValue() - alphaDiff * percent;
                break;
            }
            float alphaDiff = value.field_192518_c.floatValue() - value.field_192517_b.floatValue();
            alpha = value.field_192517_b.floatValue() + alphaDiff * percent;
            break;
        }
        GlStateManager.func_179114_b((float)(celestialAngle * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        double width = this.singleTexture.getWidth() / 4;
        double height = this.singleTexture.getHeight() / 3;
        this.singleTexture.bind();
        double xStartPos = width / (double)this.singleTexture.getWidth();
        double yStartPos = height * 2.0 / (double)this.singleTexture.getHeight();
        double xEndPos = width * 2.0 / (double)this.singleTexture.getWidth();
        double yEndPos = height * 3.0 / (double)this.singleTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        xStartPos = width / (double)this.singleTexture.getWidth();
        yStartPos = 0 / this.singleTexture.getHeight();
        xEndPos = width * 2.0 / (double)this.singleTexture.getWidth();
        yEndPos = height / (double)this.singleTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        xStartPos = width / (double)this.singleTexture.getWidth();
        yStartPos = height / (double)this.singleTexture.getHeight();
        xEndPos = width * 2.0 / (double)this.singleTexture.getWidth();
        yEndPos = height * 2.0 / (double)this.singleTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        xStartPos = width * 3.0 / (double)this.singleTexture.getWidth();
        yStartPos = height * 1.0 / (double)this.singleTexture.getHeight();
        xEndPos = width * 4.0 / (double)this.singleTexture.getWidth();
        yEndPos = height * 2.0 / (double)this.singleTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        xStartPos = width * 2.0 / (double)this.singleTexture.getWidth();
        yStartPos = height * 1.0 / (double)this.singleTexture.getHeight();
        xEndPos = width * 3.0 / (double)this.singleTexture.getWidth();
        yEndPos = height * 2.0 / (double)this.singleTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        xStartPos = 0 / this.singleTexture.getWidth();
        yStartPos = height * 1.0 / (double)this.singleTexture.getHeight();
        xEndPos = width / (double)this.singleTexture.getWidth();
        yEndPos = height * 2.0 / (double)this.singleTexture.getHeight();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(xStartPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(xEndPos, yEndPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(xEndPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(xStartPos, yStartPos).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.5f);
        GlStateManager.func_179127_m();
        GlStateManager.func_179098_w();
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
    }
}

