/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.util.noise;

import com.bloodnbonesgaming.topography.util.noise.FastNoise;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.chunk.ChunkPrimer;

public class ThreadedFastNoise
implements Runnable {
    final ChunkPrimer primer;
    final IBlockState state;
    final FastNoise noise = new FastNoise();
    final int startY;
    final int chunkX;
    final int chunkZ;
    final boolean openTop;
    final boolean closeTop;

    public ThreadedFastNoise(ChunkPrimer primer, IBlockState state, long seed, int startY, int chunkX, int chunkZ, boolean openTop, boolean closeTop) {
        this.primer = primer;
        this.state = state;
        this.noise.SetNoiseType(FastNoise.NoiseType.Cellular);
        this.noise.SetFrequency(0.005f);
        this.noise.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Natural);
        this.noise.SetCellularReturnType(FastNoise.CellularReturnType.Distance3Div);
        this.noise.SetSeed((int)seed);
        this.startY = startY;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.openTop = openTop;
        this.closeTop = closeTop;
    }

    @Override
    public void run() {
        for (int x = 0; x < 16; ++x) {
            int realX = x + this.chunkX * 16;
            for (int z = 0; z < 16; ++z) {
                int realZ = z + this.chunkZ * 16;
                for (int y = this.startY; y < this.startY + 16; ++y) {
                    double value = this.noise.GetNoise(realX, y, realZ);
                    double scale = 0.0;
                    if (this.closeTop) {
                        if (y >= 224) {
                            scale = (double)(32 - (256 - y)) / 32.0;
                        }
                    } else if (this.openTop && y >= 224) {
                        scale = -((double)(32 - (256 - y)) / 64.0);
                    }
                    if (!(value + scale > -0.15)) continue;
                }
            }
        }
    }
}

