/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.biome.provider.layers;

import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

public class GenLayerBiomeSimple
extends GenLayer {
    private final List<BiomeManager.BiomeEntry> biomes;
    private final List<BiomeManager.BiomeEntry> oceanBiomes;

    public GenLayerBiomeSimple(long seed, GenLayer parent, List<BiomeManager.BiomeEntry> biomes, List<BiomeManager.BiomeEntry> oceanBiomes) {
        super(seed);
        this.field_75909_a = parent;
        this.biomes = biomes;
        this.oceanBiomes = oceanBiomes;
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int[] parentInts;
        int arrayLength = width * depth;
        int[] returnInts = IntCache.func_76445_a((int)arrayLength);
        if (this.field_75909_a != null) {
            parentInts = this.field_75909_a.func_75904_a(chunkX, chunkZ, width, depth);
        } else {
            parentInts = IntCache.func_76445_a((int)arrayLength);
            for (int i = 0; i < parentInts.length; ++i) {
                parentInts[i] = 0;
            }
        }
        for (int z = 0; z < depth; ++z) {
            block6: for (int x = 0; x < width; ++x) {
                this.func_75903_a(x + chunkX, z + chunkZ);
                int index = x + z * width;
                int currentBiome = parentInts[index];
                int warmth = currentBiome & 0xFFFFF0FF;
                switch (warmth) {
                    case 0: {
                        if (this.oceanBiomes.size() > 0) {
                            returnInts[index] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry(this.oceanBiomes).biome);
                            continue block6;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (this.biomes.size() > 0) {
                            returnInts[index] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry(this.biomes).biome);
                            continue block6;
                        }
                        if (this.oceanBiomes.size() > 0) {
                            returnInts[index] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry(this.oceanBiomes).biome);
                            continue block6;
                        }
                        returnInts[index] = 0;
                        continue block6;
                    }
                    default: {
                        returnInts[index] = parentInts[index];
                    }
                }
            }
        }
        return returnInts;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(List<BiomeManager.BiomeEntry> biomeList) {
        boolean modded = false;
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = modded ? this.func_75902_a(totalWeight) : this.func_75902_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }
}

