/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.chunkgenerator;

import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorVoid
implements IChunkGenerator {
    protected final Random rand;
    public final World worldObj;
    public Biome[] biomesForGeneration;
    final DimensionDefinition definition;
    private final Map<Integer, Random> sizedRandoms = new HashMap<Integer, Random>();

    public ChunkGeneratorVoid(World worldIn, long seed, DimensionDefinition definition) {
        this.worldObj = worldIn;
        this.rand = new Random(seed);
        this.definition = definition;
    }

    public Chunk func_185932_a(int x, int z) {
        int regionZ;
        int regionX;
        int regionSize;
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)chunkprimer, (World)this.worldObj);
        for (Map.Entry<Integer, Random> entry : this.sizedRandoms.entrySet()) {
            regionSize = entry.getKey();
            regionX = (int)Math.floor((double)x * 16.0 / (double)regionSize);
            regionZ = (int)Math.floor((double)z * 16.0 / (double)regionSize);
            entry.getValue().setSeed((long)regionX * 341873128712L + (long)regionZ * 132897987541L + this.worldObj.func_72905_C());
        }
        for (IGenerator generator : this.definition.getGenerators()) {
            regionSize = generator.getRegionSize();
            if (regionSize == 0) {
                generator.generate(this.worldObj, chunkprimer, x, z, this.rand);
                continue;
            }
            if (!this.sizedRandoms.containsKey(regionSize)) {
                regionX = (int)Math.floor((double)x * 16.0 / (double)regionSize);
                regionZ = (int)Math.floor((double)z * 16.0 / (double)regionSize);
                this.sizedRandoms.put(regionSize, new Random((long)regionX * 341873128712L + (long)regionZ * 132897987541L + this.worldObj.func_72905_C()));
            }
            generator.generate(this.worldObj, chunkprimer, x, z, this.sizedRandoms.get(regionSize));
        }
        this.definition.getStructureHandler().generateStructures(this.worldObj, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        if (this.definition.resetRelightChecks()) {
            chunk.func_76613_n();
        }
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        int regionZ;
        int regionX;
        int regionSize;
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)false);
        for (Map.Entry<Integer, Random> entry : this.sizedRandoms.entrySet()) {
            regionSize = entry.getKey();
            regionX = (int)Math.floor((double)x * 16.0 / (double)regionSize);
            regionZ = (int)Math.floor((double)z * 16.0 / (double)regionSize);
            entry.getValue().setSeed((long)regionX * 341873128712L + (long)regionZ * 132897987541L + this.worldObj.func_72905_C());
        }
        for (IGenerator generator : this.definition.getGenerators()) {
            regionSize = generator.getRegionSize();
            if (regionSize == 0) {
                generator.populate(this.worldObj, x, z, this.rand);
                continue;
            }
            if (!this.sizedRandoms.containsKey(regionSize)) {
                regionX = (int)Math.floor((double)x * 16.0 / (double)regionSize);
                regionZ = (int)Math.floor((double)z * 16.0 / (double)regionSize);
                this.sizedRandoms.put(regionSize, new Random((long)regionX * 341873128712L + (long)regionZ * 132897987541L + this.worldObj.func_72905_C()));
            }
            generator.populate(this.worldObj, x, z, this.sizedRandoms.get(regionSize));
        }
        this.definition.getStructureHandler().populateStructures(this.worldObj, this.rand, new ChunkPos(x, z));
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.worldObj, this.rand, new BlockPos(i, 0, j)));
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.worldObj, this.rand, new BlockPos(i, 0, j)));
        WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)this.worldObj.func_180494_b(new BlockPos(i + 16, 0, j + 16)), (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return this.definition.getStructureHandler().generateStructures(this.worldObj, this.rand, chunkIn, x, z);
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (this.worldObj.func_175726_f(pos).func_76621_g()) {
            return null;
        }
        Biome biome = this.worldObj.func_180494_b(pos);
        return this.definition.getStructureHandler().getPossibleCreatures(creatureType, this.worldObj, pos, biome.func_76747_a(creatureType));
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        this.definition.getStructureHandler().recreateStructures(this.worldObj, chunkIn, x, z);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return this.definition.getStructureHandler().getNearestStructurePos(worldIn, structureName, position, findUnexplored);
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return this.definition.getStructureHandler().isInsideStructure(worldIn, structureName, pos);
    }
}

