/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.NumberHelper;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.noise.OpenSimplexNoiseGeneratorOctaves;
import com.bloodnbonesgaming.topography.util.noise.FastNoise;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.layer.GenLayer;

public class CellInterpolationTestGenerator
implements IGenerator {
    final FastNoise noise = new FastNoise();
    protected OpenSimplexNoiseGeneratorOctaves skewNoise;
    double[] smallNoiseArray = new double[825];
    double[] largeNoiseArray = new double[65536];
    IBlockState state = Blocks.field_150350_a.func_176223_P();
    boolean closeTop = false;
    boolean openTop = true;
    private final Map<MinMaxBounds, IBlockState> blocks = new LinkedHashMap<MinMaxBounds, IBlockState>();

    public CellInterpolationTestGenerator() {
        this.noise.SetNoiseType(FastNoise.NoiseType.Cellular);
        this.noise.SetFrequency(1.0f);
        this.noise.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Natural);
        this.noise.SetCellularReturnType(FastNoise.CellularReturnType.Distance3Div);
    }

    public CellInterpolationTestGenerator(ItemBlockData data) throws Exception {
        this();
        this.state = data.buildBlockState();
    }

    public void addBlock(MinMaxBounds bounds, ItemBlockData block) throws Exception {
        this.blocks.put(bounds, block.buildBlockState());
    }

    public void closeTop() {
        this.closeTop = true;
    }

    public void openTop() {
        this.openTop = true;
    }

    private void generateNoise(double[] array, int arraySizeX, int arraySizeY, int arraySizeZ, int x, int y, int z, int xCoordinateScale, int yCoordinateScale, int zCoordinateScale) {
        for (int xI = 0; xI < arraySizeX; ++xI) {
            for (int zI = 0; zI < arraySizeZ; ++zI) {
                for (int yI = 0; yI < arraySizeY; ++yI) {
                    double noise;
                    int index = (xI * arraySizeX + zI) * arraySizeY + yI;
                    array[index] = noise = (double)this.noise.GetNoise((float)(x + xI * 4) / 4.0f * 0.064f, (float)(y + yI * 8) / 8.0f * 0.128f, (float)(z + zI * 4) / 4.0f * 0.064f);
                }
            }
        }
    }

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
        this.noise.SetSeed((int)world.func_72905_C());
        this.skewNoise = new OpenSimplexNoiseGeneratorOctaves(world.func_72905_C());
        this.generateNoise(this.smallNoiseArray, 5, 33, 5, chunkX * 16, 0, chunkZ * 16, 4, 8, 4);
        NumberHelper.interpolate((double[])this.smallNoiseArray, (double[])this.largeNoiseArray, (int)5, (int)33, (int)5, (int)4, (int)8, (int)4);
        for (int x = 0; x < 16; ++x) {
            int realX = x + chunkX * 16;
            for (int z = 0; z < 16; ++z) {
                int realZ = z + chunkZ * 16;
                for (int y = 0; y < 256; ++y) {
                    double value = this.largeNoiseArray[(x * 16 + z) * 256 + y];
                    double scale = 0.0;
                    if (this.closeTop) {
                        if (y >= 224) {
                            scale = (double)(32 - (256 - y)) / 32.0;
                        }
                    } else if (this.openTop && y >= 224) {
                        scale = -((double)(32 - (256 - y)) / 64.0);
                    }
                    if (!(value + scale > -0.18)) continue;
                    IBlockState block = this.state;
                    primer.func_177855_a(x, y, z, block);
                }
            }
        }
    }

    @Override
    public GenLayer getLayer(World world, GenLayer parent) {
        return null;
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random rand) {
    }
}

