/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.animation;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.type.Pair;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.util.EnumFacing;

public abstract class AnimationKey {
    private static final HashMap<String, AnimationKey> savedKeys = new HashMap();
    public static final AnimationKey rotX = new RotationKey("rotX", EnumFacing.Axis.X);
    public static final AnimationKey rotY = new RotationKey("rotY", EnumFacing.Axis.Y);
    public static final AnimationKey rotZ = new RotationKey("rotZ", EnumFacing.Axis.Z);
    public static final AnimationKey offX = new OffsetKey("offX", EnumFacing.Axis.X);
    public static final AnimationKey offY = new OffsetKey("offY", EnumFacing.Axis.Y);
    public static final AnimationKey offZ = new OffsetKey("offZ", EnumFacing.Axis.Z);
    public final String name;

    public static Collection<AnimationKey> getKeys() {
        return savedKeys.values();
    }

    public static AnimationKey getKey(String name) {
        return savedKeys.get(name);
    }

    public static AnimationKey getRotation(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return rotX;
            }
            case Y: {
                return rotY;
            }
            case Z: {
                return rotZ;
            }
        }
        return null;
    }

    public static AnimationKey getOffset(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return offX;
            }
            case Y: {
                return offY;
            }
            case Z: {
                return offZ;
            }
        }
        return null;
    }

    AnimationKey(String name) {
        this.name = name;
        if (savedKeys.containsKey(name)) {
            throw new RuntimeException("Duplicate AnimationKey name=" + name);
        }
        savedKeys.put(name, this);
    }

    public double getDefault() {
        return 0.0;
    }

    public abstract boolean isAligned(double var1);

    public abstract Pair<AnimationKey, Double> transform(Rotation var1, double var2);

    public String toString() {
        return this.name;
    }

    public static class OffsetKey
    extends AnimationKey {
        public final EnumFacing.Axis axis;

        OffsetKey(String name, EnumFacing.Axis axis) {
            super(name);
            this.axis = axis;
        }

        @Override
        public boolean isAligned(double value) {
            return true;
        }

        @Override
        public Pair<AnimationKey, Double> transform(Rotation rotation, double value) {
            return new Pair((Object)OffsetKey.getOffset(rotation.getRotatedComponent(this.axis)), (Object)(rotation.getRotatedComponentPositive(this.axis) ? value : -value));
        }
    }

    public static class RotationKey
    extends AnimationKey {
        public final EnumFacing.Axis axis;

        RotationKey(String name, EnumFacing.Axis axis) {
            super(name);
            this.axis = axis;
        }

        @Override
        public boolean isAligned(double value) {
            return value % 360.0 == 0.0;
        }

        @Override
        public Pair<AnimationKey, Double> transform(Rotation rotation, double value) {
            return new Pair((Object)RotationKey.getRotation(rotation.getRotatedComponent(this.axis)), (Object)(rotation.getRotatedComponentPositive(this.axis) ? value : -value));
        }
    }
}

