/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.location;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mcmoddev.orespawn.api.BiomeLocation;
import java.util.Collection;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public final class BiomeLocationDictionary
implements BiomeLocation {
    private final BiomeDictionary.Type type;
    private final int hash;

    public BiomeLocationDictionary(BiomeDictionary.Type type) {
        this.type = type;
        this.hash = type.hashCode();
    }

    @Override
    public boolean matches(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)this.type);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof BiomeLocationDictionary && this.type.equals(((BiomeLocationDictionary)obj).type);
    }

    public BiomeDictionary.Type getType() {
        return this.type;
    }

    @Override
    public ImmutableList<Biome> getBiomes() {
        return ImmutableList.copyOf((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)this.type));
    }

    @Override
    public JsonElement serialize() {
        return new JsonPrimitive(this.type.toString().toUpperCase());
    }
}

