/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;

public final class GuiDrawing {
    private GuiDrawing() {
    }

    public static void rect(ResourceLocation texture, int left, int top, int width, int height, int color) {
        GuiDrawing.rect(texture, left, top, width, height, 0.0f, 0.0f, 1.0f, 1.0f, color);
    }

    public static void rect(ResourceLocation texture, int left, int top, int width, int height, float u1, float v1, float u2, float v2, int color) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)left, (double)(top + height), 0.0).func_187315_a((double)u1, (double)v2).func_181675_d();
        buffer.func_181662_b((double)(left + width), (double)(top + height), 0.0).func_187315_a((double)u2, (double)v2).func_181675_d();
        buffer.func_181662_b((double)(left + width), (double)top, 0.0).func_187315_a((double)u2, (double)v1).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a((double)u1, (double)v1).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
    }

    public static void rect(int left, int top, int width, int height, int color) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)left, (double)(top + height), 0.0).func_181675_d();
        buffer.func_181662_b((double)(left + width), (double)(top + height), 0.0).func_181675_d();
        buffer.func_181662_b((double)(left + width), (double)top, 0.0).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void rect(Fluid fluid, int left, int top, int width, int height, float u1, float v1, float u2, float v2, int color) {
        ResourceLocation fluidTexture = fluid.getStill();
        TextureAtlasSprite tas = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidTexture.toString());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)left, (double)(top + height), 0.0).func_187315_a((double)tas.func_94214_a((double)u1), (double)tas.func_94207_b((double)v2)).func_181675_d();
        buffer.func_181662_b((double)(left + width), (double)(top + height), 0.0).func_187315_a((double)tas.func_94214_a((double)u2), (double)tas.func_94207_b((double)v2)).func_181675_d();
        buffer.func_181662_b((double)(left + width), (double)top, 0.0).func_187315_a((double)tas.func_94214_a((double)u2), (double)tas.func_94207_b((double)v1)).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a((double)tas.func_94214_a((double)u1), (double)tas.func_94207_b((double)v1)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
    }

    public static void rect(Fluid fluid, int left, int top, int width, int height, int color) {
        GuiDrawing.rect(fluid, left, top, width, height, 0.0f, 0.0f, 16.0f, 16.0f, color);
    }

    public static void drawGuiPanel(int x, int y, int width, int height) {
        GuiDrawing.drawGuiPanel(x, y, width, height, 0x555555, 0xC6C6C6, 0xFFFFFF, 0);
    }

    public static void drawGuiPanel(int x, int y, int width, int height, int shadow, int panel, int hilight, int outline) {
        GuiDrawing.rect(x + 3, y + 3, width - 6, height - 6, panel);
        GuiDrawing.rect(x + 2, y + 1, width - 4, 2, hilight);
        GuiDrawing.rect(x + 2, y + height - 3, width - 4, 2, shadow);
        GuiDrawing.rect(x + 1, y + 2, 2, height - 4, hilight);
        GuiDrawing.rect(x + width - 3, y + 2, 2, height - 4, shadow);
        GuiDrawing.rect(x + width - 3, y + 2, 1, 1, panel);
        GuiDrawing.rect(x + 2, y + height - 3, 1, 1, panel);
        GuiDrawing.rect(x + 3, y + 3, 1, 1, hilight);
        GuiDrawing.rect(x + width - 4, y + height - 4, 1, 1, shadow);
        GuiDrawing.rect(x + 2, y, width - 4, 1, outline);
        GuiDrawing.rect(x, y + 2, 1, height - 4, outline);
        GuiDrawing.rect(x + width - 1, y + 2, 1, height - 4, outline);
        GuiDrawing.rect(x + 2, y + height - 1, width - 4, 1, outline);
        GuiDrawing.rect(x + 1, y + 1, 1, 1, outline);
        GuiDrawing.rect(x + 1, y + height - 2, 1, 1, outline);
        GuiDrawing.rect(x + width - 2, y + 1, 1, 1, outline);
        GuiDrawing.rect(x + width - 2, y + height - 2, 1, 1, outline);
    }

    public static void drawBeveledPanel(int x, int y) {
        GuiDrawing.drawBeveledPanel(x, y, 18, 18, 0x373737, 0x8B8B8B, 0xFFFFFF);
    }

    public static void drawBeveledPanel(int x, int y, int width, int height) {
        GuiDrawing.drawBeveledPanel(x, y, width, height, 0x373737, 0x8B8B8B, 0xFFFFFF);
    }

    public static void drawBeveledPanel(int x, int y, int width, int height, int topleft, int panel, int bottomright) {
        GuiDrawing.rect(x, y, width, height, panel);
        GuiDrawing.rect(x, y, width - 1, 1, topleft);
        GuiDrawing.rect(x, y + 1, 1, height - 2, topleft);
        GuiDrawing.rect(x + width - 1, y + 1, 1, height - 1, bottomright);
        GuiDrawing.rect(x + 1, y + height - 1, width - 1, 1, bottomright);
    }

    public static void drawString(String s, int x, int y, int color) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(s, x, y, color);
    }

    public static void drawTooltip(String s, int x, int y) {
    }
}

