/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.table;

import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.table.ITieredRecipe;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShaped;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShapeless;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TableRecipeManager {
    private static final TableRecipeManager INSTANCE = new TableRecipeManager();
    private List recipes = new ArrayList();

    public static final TableRecipeManager getInstance() {
        return INSTANCE;
    }

    public TableRecipeShaped addShaped(ItemStack result, Object ... recipe) {
        return this.addShaped(0, result, recipe);
    }

    public TableRecipeShaped addShaped(int tier, ItemStack result, Object ... recipe) {
        TableRecipeShaped craft = new TableRecipeShaped(tier, result, recipe);
        if (ModConfig.confTableEnabled) {
            this.recipes.add(craft);
        }
        return craft;
    }

    public TableRecipeShapeless addShapeless(ItemStack result, Object ... ingredients) {
        return this.addShapeless(0, result, ingredients);
    }

    public TableRecipeShapeless addShapeless(int tier, ItemStack result, Object ... ingredients) {
        TableRecipeShapeless recipe = new TableRecipeShapeless(tier, result, ingredients);
        if (ModConfig.confTableEnabled) {
            this.recipes.add(recipe);
        }
        return recipe;
    }

    public ItemStack findMatchingRecipe(InventoryCrafting grid, World world) {
        int j;
        int i = 0;
        ItemStack stack = ItemStack.field_190927_a;
        ItemStack stack1 = ItemStack.field_190927_a;
        for (j = 0; j < grid.func_70302_i_(); ++j) {
            ItemStack stack2 = grid.func_70301_a(j);
            if (stack2.func_190926_b()) continue;
            if (i == 0) {
                stack = stack2;
            }
            if (i == 1) {
                stack1 = stack2;
            }
            ++i;
        }
        if (i == 2 && stack.func_77973_b() == stack1.func_77973_b() && stack.func_190916_E() == 1 && stack1.func_190916_E() == 1 && stack.func_77973_b().isRepairable()) {
            Item item = stack.func_77973_b();
            int j1 = item.func_77612_l() - stack.func_77952_i();
            int k = item.func_77612_l() - stack1.func_77952_i();
            int l = j1 + k + item.func_77612_l() * 5 / 100;
            int i1 = item.func_77612_l() - l;
            if (i1 < 0) {
                i1 = 0;
            }
            return new ItemStack(stack.func_77973_b(), 1, i1);
        }
        for (j = 0; j < this.recipes.size(); ++j) {
            IRecipe recipe = (IRecipe)this.recipes.get(j);
            if (!recipe.func_77569_a(grid, world)) continue;
            return recipe.func_77572_b(grid);
        }
        if (ModConfig.confTableUseRecipes && grid.func_174922_i() == 3 && grid.func_174923_h() == 3) {
            for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
                if (!recipe.func_77569_a(grid, world)) continue;
                return recipe.func_77572_b(grid);
            }
        }
        return ItemStack.field_190927_a;
    }

    public List getRecipes() {
        return this.recipes;
    }

    public void removeRecipes(ItemStack stack) {
        this.recipes.removeIf(o -> o instanceof IRecipe && ((IRecipe)o).func_77571_b().func_77969_a(stack));
    }

    public List getRecipes(int size) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (Object o : this.getRecipes()) {
            IRecipe recipe = (IRecipe)o;
            if (!recipe.func_194133_a(size, size)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    public List getRecipesTiered(int tier) {
        ArrayList<ITieredRecipe> recipes = new ArrayList<ITieredRecipe>();
        for (Object o : this.getRecipes()) {
            ITieredRecipe recipe;
            if (!(o instanceof ITieredRecipe) || (recipe = (ITieredRecipe)o).getTier() != tier) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    public static NonNullList<ItemStack> getRemainingItems(InventoryCrafting grid, World world) {
        for (int j = 0; j < TableRecipeManager.getInstance().recipes.size(); ++j) {
            IRecipe recipe = (IRecipe)TableRecipeManager.getInstance().recipes.get(j);
            if (!recipe.func_77569_a(grid, world)) continue;
            return recipe.func_179532_b(grid);
        }
        return CraftingManager.func_180303_b((InventoryCrafting)grid, (World)world);
    }
}

