/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.tictim.ceu.CeuResources;
import com.tictim.ceu.config.CeuConfig;
import com.tictim.ceu.enums.CeuType;
import com.tictim.ceu.enums.ConverterType;
import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.message.MessageConfigSync;
import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.mte.MTEInfiniteEnergy;
import com.tictim.ceu.util.CeuCraftingHelper;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.metatileentity.MetaTileEntity;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="ceu", name="Ceu", version="1.0.4.0", dependencies="required-after:gregtech;", guiFactory="com.tictim.ceu.config.CeuConfigGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class Ceu {
    public static final String MODID = "ceu";
    public static final String NAME = "Ceu";
    public static final String VERSION = "1.0.4.0";
    public static final SimpleNetworkWrapper NET = NetworkRegistry.INSTANCE.newSimpleChannel("ceu");
    public static final ListMultimap<CeuType, MTECeu> mteCeus = ArrayListMultimap.create();
    public static final Map<Energy, MTEInfiniteEnergy> energyEmitters = new EnumMap<Energy, MTEInfiniteEnergy>(Energy.class);
    public static final Map<Energy, MTEInfiniteEnergy> energyReceivers = new EnumMap<Energy, MTEInfiniteEnergy>(Energy.class);

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        CeuResources.init();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CeuConfig.load(event);
        int id = 10650;
        for (ConverterType converterType : ConverterType.values()) {
            for (int tier = converterType.getMinTier(); tier < converterType.getMaxTier(); ++tier) {
                for (int slot = 1; slot <= 4; ++slot) {
                    String vn = GTValues.VN[tier].toLowerCase();
                    mteCeus.put((Object)converterType.getCeuType(), (Object)GregTechAPI.registerMetaTileEntity((int)id++, (MetaTileEntity)new MTECeu(new ResourceLocation(MODID, converterType.getCeuType() + "." + vn + "." + slot * slot), tier, converterType.getCeuType(), slot)));
                    mteCeus.put((Object)converterType.getCefType(), (Object)GregTechAPI.registerMetaTileEntity((int)id++, (MetaTileEntity)new MTECeu(new ResourceLocation(MODID, converterType.getCefType() + "." + vn + "." + slot * slot), tier, converterType.getCefType(), slot)));
                }
            }
        }
        id = 10649;
        for (Enum enum_ : Energy.values()) {
            energyEmitters.put((Energy)enum_, (MTEInfiniteEnergy)GregTechAPI.registerMetaTileEntity((int)id--, (MetaTileEntity)new MTEInfiniteEnergy(new ResourceLocation(MODID, ((Energy)enum_).getRawName() + "_emitter"), (Energy)enum_, true)));
            energyReceivers.put((Energy)enum_, (MTEInfiniteEnergy)GregTechAPI.registerMetaTileEntity((int)id--, (MetaTileEntity)new MTEInfiniteEnergy(new ResourceLocation(MODID, ((Energy)enum_).getRawName() + "_receiver"), (Energy)enum_, false)));
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (CeuType type : CeuType.values()) {
            if (!mteCeus.containsKey((Object)type)) continue;
            mteCeus.get((Object)type).forEach(CeuCraftingHelper.HELPER.logic(type));
        }
        NET.registerMessage((IMessageHandler)new MessageConfigSync.Handler(), MessageConfigSync.class, 0, Side.CLIENT);
    }
}

