/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.config;

import com.tictim.ceu.config.CeuConfig;
import com.tictim.ceu.enums.Energy;
import net.minecraft.nbt.NBTTagCompound;

public class InfiniteEnergySourceSetting {
    private final boolean[] emitterDisabled = new boolean[Energy.values().length];
    private final boolean[] receiverDisabled = new boolean[Energy.values().length];

    public InfiniteEnergySourceSetting() {
        for (Energy e : Energy.values()) {
            this.emitterDisabled[e.ordinal()] = CeuConfig.cfg.get("general.infinite_energy_emitter", InfiniteEnergySourceSetting.getEmitterDisabledOptionName(e), e.isEmitterDisabledByDefault()).getBoolean();
            this.receiverDisabled[e.ordinal()] = CeuConfig.cfg.get("general.infinite_energy_receiver", InfiniteEnergySourceSetting.getReceiverDisabledOptionName(e), e.isReceiverDisabledByDefault()).getBoolean();
        }
    }

    public InfiniteEnergySourceSetting(NBTTagCompound nbt) {
        for (Energy e : Energy.values()) {
            this.emitterDisabled[e.ordinal()] = nbt.func_74767_n(InfiniteEnergySourceSetting.getEmitterDisabledOptionName(e));
            this.emitterDisabled[e.ordinal()] = nbt.func_74767_n(InfiniteEnergySourceSetting.getReceiverDisabledOptionName(e));
        }
    }

    public void serialize(NBTTagCompound nbt) {
        for (Energy e : Energy.values()) {
            if (this.emitterDisabled[e.ordinal()]) {
                nbt.func_74757_a(InfiniteEnergySourceSetting.getEmitterDisabledOptionName(e), true);
            }
            if (!this.receiverDisabled[e.ordinal()]) continue;
            nbt.func_74757_a(InfiniteEnergySourceSetting.getReceiverDisabledOptionName(e), true);
        }
    }

    private static String getEmitterDisabledOptionName(Energy energy) {
        return "disable" + energy.name() + "Emitter";
    }

    private static String getReceiverDisabledOptionName(Energy energy) {
        return "disable" + energy.name() + "Receiver";
    }

    public boolean isEnergyEmitterDisabled(Energy e) {
        return this.emitterDisabled[e.ordinal()];
    }

    public boolean isEnergyReceiverDisabled(Energy e) {
        return this.receiverDisabled[e.ordinal()];
    }
}

