/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait;

import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.mte.trait.TraitCeu;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class TraitGteuOut
extends TraitCeu.TraitCeuCapabilityBasedEmitter<IEnergyContainer>
implements IEnergyContainer {
    public TraitGteuOut(MTECeu ceu) {
        super(ceu);
    }

    @Override
    protected void operate(IEnergyContainer energy) {
        if (energy.inputsEnergy(this.ceu.getFrontFacing().func_176734_d())) {
            long ampere;
            long volt = this.ceu.getEnergyStorage().getOutputVoltage();
            long amp = this.ceu.getEnergyStorage().getOutputAmperage();
            long energyStored = this.ceu.extractEU(Long.MAX_VALUE, true, true);
            if (energyStored > volt && (ampere = Math.min(amp, energyStored / volt)) > 0L && (ampere = energy.acceptEnergyFromNetwork(this.ceu.getFrontFacing().func_176734_d(), volt, ampere)) > 0L) {
                this.ceu.extractEU(volt * ampere, true, false);
            }
        }
    }

    public String getName() {
        return "TraitGteuOut";
    }

    public int getNetworkID() {
        return 1;
    }

    @Override
    protected Capability<IEnergyContainer> getImplementingCapability() {
        return GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER;
    }

    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        return 0L;
    }

    public boolean inputsEnergy(EnumFacing side) {
        return false;
    }

    public boolean outputsEnergy(EnumFacing side) {
        return true;
    }

    public long changeEnergy(long differenceAmount) {
        return 0L;
    }

    public long getEnergyStored() {
        return this.ceu.getEUStoredSum(true);
    }

    public long getEnergyCapacity() {
        return this.ceu.getEUCapacitySum(true);
    }

    public long getInputAmperage() {
        return this.ceu.getEnergyStorage().getInputAmperage();
    }

    public long getInputVoltage() {
        return this.ceu.getEnergyStorage().getInputVoltage();
    }
}

