/*
 * Decompiled with CFR 0.152.
 */
package jackyy.dimensionaledibles.block;

import jackyy.dimensionaledibles.block.BlockCakeBase;
import jackyy.dimensionaledibles.block.tile.TileDimensionCake;
import jackyy.dimensionaledibles.registry.ModConfig;
import jackyy.dimensionaledibles.util.TeleporterHandler;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockNetherCake
extends BlockCakeBase
implements ITileEntityProvider {
    public BlockNetherCake() {
        this.setRegistryName("dimensionaledibles:nether_cake");
        this.func_149663_c("dimensionaledibles.nether_cake");
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int meta = this.func_176201_c(world.func_180495_p(pos)) - 1;
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == Item.field_150901_e.func_82594_a((Object)new ResourceLocation(ModConfig.tweaks.netherCake.fuel))) {
            if (meta >= 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(meta)), 2);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
        } else if (world.field_73011_w.getDimension() != -1 && !world.field_72995_K) {
            if (player.field_71075_bZ.field_75098_d || !ModConfig.tweaks.netherCake.consumeFuel) {
                this.teleportPlayer(world, player);
            } else {
                this.consumeCake(world, pos, player);
            }
            return true;
        }
        return false;
    }

    private void teleportPlayer(World world, EntityPlayer player) {
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        BlockPos coords = ModConfig.tweaks.netherCake.useCustomCoords ? new BlockPos(ModConfig.tweaks.netherCake.customCoords.x, ModConfig.tweaks.netherCake.customCoords.y, ModConfig.tweaks.netherCake.customCoords.z) : TeleporterHandler.getDimPos(playerMP, -1, player.func_180425_c());
        TeleporterHandler.updateDimPos((EntityPlayer)playerMP, world.field_73011_w.getDimension(), player.func_180425_c());
        TeleporterHandler.teleport(playerMP, -1, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), playerMP.field_71133_b.func_184103_al());
    }

    private void consumeCake(World world, BlockPos pos, EntityPlayer player) {
        int l;
        if (player.func_71043_e(true) && (l = ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)BITES)).intValue()) < 6) {
            player.func_71024_bL().func_75122_a(2, 0.1f);
            world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(l + 1)), 3);
            this.teleportPlayer(world, player);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return ModConfig.tweaks.netherCake.preFueled ? this.func_176223_P().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(0)) : this.func_176223_P().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(6));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (ModConfig.general.netherCake) {
            list.add((Object)new ItemStack((Block)this));
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileDimensionCake(-1, "Nether");
    }
}

