/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.widgets.ISearchable;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WLabel;
import me.towdium.jecalculation.gui.widgets.WLabelGroup;
import me.towdium.jecalculation.gui.widgets.WRectangle;
import me.towdium.jecalculation.gui.widgets.WScroll;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class WLabelScroll
extends WContainer
implements ISearchable {
    protected List<ILabel> labels = new ArrayList<ILabel>();
    protected List<ILabel> filtered = new ArrayList<ILabel>();
    protected WLabelGroup labelGroup;
    protected WScroll scroll;
    protected int xPos;
    protected int yPos;
    protected int column;
    protected int row;
    protected int current;
    protected String filter = "";
    protected IWidget.ListenerValue<? super WLabelScroll, Integer> listener;

    public WLabelScroll(int xPos, int yPos, int column, int row, WLabel.Mode mode, boolean drawConnection) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.column = column;
        this.row = row;
        this.labelGroup = new WLabelGroup(xPos, yPos, column, row, mode).setListener((? super WLabelGroup i, Integer v) -> {
            if (this.listener != null) {
                this.listener.invoke(this, column * this.current + v);
            }
        });
        this.scroll = new WScroll(xPos + column * 18 + 4, yPos, row * 18).setListener((? super WScroll i) -> this.update(i.getCurrent()));
        this.add((IWidget)this.labelGroup);
        this.add((IWidget)this.scroll);
        if (drawConnection) {
            this.add((IWidget)new WRectangle(xPos + column * 18, yPos, 4, row * 18, -6184543));
        }
    }

    public void update(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        int step = this.getStepAmount();
        this.current = (int)((float)step * f);
        if (this.current == step) {
            --this.current;
        }
        this.labelGroup.setLabel(this.filtered, this.current * this.column);
    }

    @Override
    public boolean onScroll(JecaGui gui, int xMouse, int yMouse, int diff) {
        boolean in = JecaGui.mouseIn(this.xPos, this.yPos, this.column * 18, this.row * 18, xMouse, yMouse);
        if (in) {
            float pos = this.getPos(this.current - diff);
            this.scroll.setCurrent(pos);
            this.update(pos);
        }
        return in;
    }

    public ILabel get(int index) {
        return this.filtered.get(index);
    }

    private float getPos(int step) {
        return 1.0f / (float)(this.getStepAmount() - 1) * (float)step;
    }

    public WLabelScroll setLabels(List<ILabel> labels) {
        this.labels = labels;
        this.setFilter(this.filter);
        return this;
    }

    @Override
    public boolean setFilter(String str) {
        this.filter = str;
        this.filtered = this.labels.stream().filter(l -> Utilities.I18n.contains(l.getDisplayName().toLowerCase(), str.toLowerCase())).collect(Collectors.toList());
        this.scroll.setCurrent(0.0f);
        this.update(0.0f);
        return this.filtered.size() != 0;
    }

    public WLabelScroll setListener(IWidget.ListenerValue<? super WLabelScroll, Integer> listener) {
        this.listener = listener;
        return this;
    }

    private int getStepAmount() {
        int line = (this.labels.size() + this.column - 1) / this.column;
        return Math.max(line - this.row + 1, 1);
    }
}

