/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.tileentities;

import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.tileentities.ValveBlockEntity;

public class TankBlockEntity
extends TileEntity {
    private int fillLevel = 0;
    private boolean isPartOfTank = false;
    private BlockPos valveCoords = null;
    private boolean[] connections = new boolean[6];

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.fillLevel = tag.func_74771_c("FillLevel");
        this.isPartOfTank = tag.func_74767_n("isPartOfTank");
        if (this.isPartOfTank) {
            int[] valveCoordsArray = tag.func_74759_k("ValveCoords");
            this.valveCoords = new BlockPos(valveCoordsArray[0], valveCoordsArray[1], valveCoordsArray[2]);
        }
        this.connections = new boolean[6];
        this.connections[EnumFacing.DOWN.func_176745_a()] = tag.func_74767_n("Y-");
        this.connections[EnumFacing.UP.func_176745_a()] = tag.func_74767_n("Y+");
        this.connections[EnumFacing.NORTH.func_176745_a()] = tag.func_74767_n("Z-");
        this.connections[EnumFacing.SOUTH.func_176745_a()] = tag.func_74767_n("Z+");
        this.connections[EnumFacing.WEST.func_176745_a()] = tag.func_74767_n("X-");
        this.connections[EnumFacing.EAST.func_176745_a()] = tag.func_74767_n("X+");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("FillLevel", (byte)this.fillLevel);
        tag.func_74757_a("isPartOfTank", this.isPartOfTank);
        if (this.valveCoords != null) {
            int[] valveCoordsArray = new int[]{this.valveCoords.func_177958_n(), this.valveCoords.func_177956_o(), this.valveCoords.func_177952_p()};
            tag.func_74783_a("ValveCoords", valveCoordsArray);
        }
        tag.func_74757_a("Y-", this.connections[EnumFacing.DOWN.func_176745_a()]);
        tag.func_74757_a("Y+", this.connections[EnumFacing.UP.func_176745_a()]);
        tag.func_74757_a("Z-", this.connections[EnumFacing.NORTH.func_176745_a()]);
        tag.func_74757_a("Z+", this.connections[EnumFacing.SOUTH.func_176745_a()]);
        tag.func_74757_a("X-", this.connections[EnumFacing.WEST.func_176745_a()]);
        tag.func_74757_a("X+", this.connections[EnumFacing.EAST.func_176745_a()]);
        return tag;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.func_189515_b(tag);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        int oldFillLevel = this.fillLevel;
        boolean wasPartOfTank = this.isPartOfTank;
        boolean[] oldConnections = Arrays.copyOf(this.connections, this.connections.length);
        this.func_145839_a(packet.func_148857_g());
        if (wasPartOfTank != this.isPartOfTank || oldFillLevel != this.fillLevel || !Arrays.equals(oldConnections, this.connections)) {
            Utils.syncBlockAndRerender(this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean isPartOfTank() {
        return this.isPartOfTank && this.valveCoords != null;
    }

    public boolean isEmpty() {
        return this.fillLevel == 0;
    }

    public ValveBlockEntity getValve() {
        if (this.isPartOfTank()) {
            return Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, ValveBlockEntity.class, this.valveCoords);
        }
        return null;
    }

    public boolean setValve(BlockPos pos) {
        if (this.isPartOfTank() || pos == null) {
            return false;
        }
        ValveBlockEntity valveEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, ValveBlockEntity.class, pos);
        if (valveEntity != null) {
            this.valveCoords = pos;
            this.isPartOfTank = true;
            return true;
        }
        return false;
    }

    public int getFillLevel() {
        return this.fillLevel;
    }

    public boolean setFillLevel(int level, boolean forceBlockUpdate) {
        boolean levelChanged = (level = MathHelper.func_76125_a((int)level, (int)0, (int)16)) != this.fillLevel;
        this.fillLevel = level;
        if (levelChanged || forceBlockUpdate) {
            Utils.syncBlockAndRerender(this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
        }
        return levelChanged;
    }

    public Fluid getFluid() {
        FluidStack fluidStack;
        ValveBlockEntity valve = this.getValve();
        if (valve != null && (fluidStack = valve.getFluid()) != null) {
            return fluidStack.getFluid();
        }
        return null;
    }

    public boolean isConnected(EnumFacing side) {
        if (side == null) {
            return false;
        }
        return this.connections[side.func_176745_a()];
    }

    public boolean hasValveAt(BlockPos pos) {
        if (!this.isPartOfTank() || pos == null) {
            return false;
        }
        return pos.equals((Object)this.valveCoords);
    }

    public void updateConnections() {
        this.connections[EnumFacing.EAST.func_176745_a()] = this.shouldConnectTo(this.field_174879_c.func_177974_f());
        this.connections[EnumFacing.WEST.func_176745_a()] = this.shouldConnectTo(this.field_174879_c.func_177976_e());
        this.connections[EnumFacing.UP.func_176745_a()] = this.shouldConnectTo(this.field_174879_c.func_177984_a());
        this.connections[EnumFacing.DOWN.func_176745_a()] = this.shouldConnectTo(this.field_174879_c.func_177977_b());
        this.connections[EnumFacing.SOUTH.func_176745_a()] = this.shouldConnectTo(this.field_174879_c.func_177968_d());
        this.connections[EnumFacing.NORTH.func_176745_a()] = this.shouldConnectTo(this.field_174879_c.func_177978_c());
    }

    private boolean shouldConnectTo(BlockPos checkPos) {
        if (checkPos.func_177958_n() < this.field_174879_c.func_177958_n() - 1 || checkPos.func_177958_n() > this.field_174879_c.func_177958_n() + 1 || checkPos.func_177956_o() < this.field_174879_c.func_177956_o() - 1 || checkPos.func_177956_o() > this.field_174879_c.func_177956_o() + 1 || checkPos.func_177952_p() < this.field_174879_c.func_177952_p() - 1 || checkPos.func_177952_p() > this.field_174879_c.func_177952_p() + 1) {
            return false;
        }
        TankBlockEntity connectionCandidate = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, checkPos);
        if (connectionCandidate != null) {
            return connectionCandidate.hasValveAt(this.valveCoords);
        }
        return false;
    }

    public void disconnect(boolean suppressBlockUpdates) {
        this.isPartOfTank = false;
        this.fillLevel = 0;
        this.valveCoords = null;
        Arrays.fill(this.connections, false);
        if (!suppressBlockUpdates) {
            Utils.syncBlockAndRerender(this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
        }
    }
}

