/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.commands.commands.debug;

import java.beans.ConstructorProperties;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.exception.DelayPacketException;
import logisticspipes.network.packets.debuggui.DebugDataPacket;
import logisticspipes.network.packets.debuggui.DebugPanelOpen;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.debug.api.IDataConnection;
import network.rs485.debug.api.IDebugGuiEntry;
import network.rs485.debug.api.IObjectIdentification;

public class DebugGuiController {
    private static transient DebugGuiController instance;
    private HashMap<EntityPlayer, IDebugGuiEntry> serverDebugger = new HashMap();
    private List<IDataConnection> serverList = new LinkedList<IDataConnection>();
    private IDebugGuiEntry clientController = null;
    private List<Future<IDataConnection>> clientList = new LinkedList<Future<IDataConnection>>();

    private DebugGuiController() {
    }

    public static DebugGuiController instance() {
        if (instance == null) {
            instance = new DebugGuiController();
        }
        return instance;
    }

    public void execClient() {
        if (this.clientController != null) {
            this.clientController.exec();
        }
    }

    public void execServer() {
        this.serverDebugger.values().forEach(IDebugGuiEntry::exec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWatchingOf(Object object, EntityPlayer player) {
        if (object == null) {
            return;
        }
        IDebugGuiEntry entry = this.serverDebugger.get(player);
        if (entry == null) {
            try {
                entry = IDebugGuiEntry.create();
                this.serverDebugger.put(player, entry);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return;
            }
        }
        if (entry == null) {
            System.out.println("DebugGui could not be loaded");
            return;
        }
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(DebugPanelOpen.class).setName(object.getClass().getSimpleName()), player);
        List<IDataConnection> list = this.serverList;
        synchronized (list) {
            int identification = this.serverList.size();
            DataConnectionServer conIn = new DataConnectionServer(identification, player);
            while (this.serverList.size() <= identification) {
                this.serverList.add(null);
            }
            this.serverList.set(identification, entry.startServerDebugging(object, conIn, new ObjectIdentification()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewDebugGui(String name, int identification) {
        if (this.clientController == null) {
            try {
                this.clientController = IDebugGuiEntry.create();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return;
            }
        }
        List<Future<IDataConnection>> list = this.clientList;
        synchronized (list) {
            while (this.clientList.size() <= identification) {
                this.clientList.add(null);
            }
            this.clientList.set(identification, this.clientController.startClientDebugging(name, new DataConnectionClient(identification)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDataPacket(byte[] payload, int identifier, EntityPlayer player) {
        if (MainProxy.isServer((IBlockAccess)player.func_130014_f_())) {
            List<IDataConnection> list = this.serverList;
            synchronized (list) {
                IDataConnection connection = this.serverList.get(identifier);
                if (connection != null) {
                    connection.passData(payload);
                }
            }
        }
        List<Future<IDataConnection>> list = this.clientList;
        synchronized (list) {
            Future<IDataConnection> connectionFuture;
            try {
                connectionFuture = this.clientList.get(identifier);
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println(this.clientList);
                throw e;
            }
            if (connectionFuture == null || !connectionFuture.isDone()) {
                throw new DelayPacketException();
            }
            IDataConnection connection = null;
            try {
                connection = connectionFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            if (connection == null) {
                throw new DelayPacketException();
            }
            connection.passData(payload);
        }
    }

    static {
        Launch.classLoader.addTransformerExclusion("com.trolltech.qt.");
        Launch.classLoader.addTransformerExclusion("network.rs485.debuggui.");
    }

    private static class ObjectIdentification
    implements IObjectIdentification {
        private ObjectIdentification() {
        }

        @Override
        public boolean toStringObject(Object o) {
            return o.getClass() == EnumFacing.class || o.getClass() == ItemIdentifier.class || o.getClass() == ItemIdentifierStack.class;
        }

        @Override
        public String handleObject(Object o) {
            if (o instanceof World) {
                return ((World)o).func_72912_H().func_76065_j();
            }
            if (o != null && o.getClass().isArray() && Array.getLength(o) > 100) {
                return "(Too big)";
            }
            return null;
        }
    }

    private class DataConnectionClient
    implements IDataConnection {
        private int identification;

        @Override
        public void passData(byte[] packet) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(DebugDataPacket.class).setPayload(packet).setIdentifier(this.identification));
        }

        @Override
        public void closeCon() {
            DebugGuiController.this.clientList.set(this.identification, null);
        }

        @ConstructorProperties(value={"identification"})
        public DataConnectionClient(int identification) {
            this.identification = identification;
        }
    }

    private class DataConnectionServer
    implements IDataConnection {
        private int identification;
        private EntityPlayer player;

        @Override
        public void passData(byte[] packet) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(DebugDataPacket.class).setPayload(packet).setIdentifier(this.identification), this.player);
        }

        @Override
        public void closeCon() {
            DebugGuiController.this.serverList.set(this.identification, null);
        }

        @ConstructorProperties(value={"identification", "player"})
        public DataConnectionServer(int identification, EntityPlayer player) {
            this.identification = identification;
            this.player = player;
        }
    }
}

