/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.exception.TargetNotFoundException;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public abstract class SlotPacket
extends ModernPacket {
    private int integer;

    public SlotPacket(int id) {
        super(id);
    }

    public <T extends Slot> T getSlot(EntityPlayer player, Class<T> clazz) {
        if (player.field_71070_bA instanceof DummyContainer) {
            if (this.getInteger() >= player.field_71070_bA.field_75151_b.size()) {
                this.targetNotFound("The requested Slot was out of range");
            } else {
                Slot slot = player.field_71070_bA.func_75139_a(this.getInteger());
                if (slot == null) {
                    this.targetNotFound("The requested Slot was null");
                } else if (!clazz.isAssignableFrom(slot.getClass())) {
                    this.targetNotFound("Couldn't find " + clazz.getName() + ", found slot with " + slot.getClass());
                } else {
                    return (T)slot;
                }
            }
        }
        return null;
    }

    public SlotPacket setSlot(Slot slot) {
        this.setInteger(slot.field_75222_d);
        return this;
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.setInteger(input.readInt());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.getInteger());
    }

    protected void targetNotFound(String message) {
        throw new TargetNotFoundException(message, this);
    }

    private SlotPacket setInteger(int integer) {
        this.integer = integer;
        return this;
    }

    protected int getInteger() {
        return this.integer;
    }
}

