/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.ILPItemAcceptor;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class ItemInsertionHandler
implements IItemHandler {
    public static final List<ILPItemAcceptor> ACCEPTORS = new ArrayList<ILPItemAcceptor>();
    private final LogisticsTileGenericPipe pipe;
    private final EnumFacing dir;

    public ItemInsertionHandler(LogisticsTileGenericPipe pipe, EnumFacing dir) {
        this.pipe = pipe;
        this.dir = dir;
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!simulate) {
            ItemInsertionHandler.handleItemInsetion(this.pipe, this.dir, stack);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public static ItemStack handleItemInsetion(LogisticsTileGenericPipe pipe, EnumFacing from, ItemStack stack) {
        for (ILPItemAcceptor acceptor : ACCEPTORS) {
            if (!acceptor.accept(pipe, from, stack)) continue;
            return ItemStack.field_190927_a;
        }
        return pipe.insertItem(from, stack);
    }
}

