/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe.tube;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.tubes.HSTubeSpeedup;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.I3DOperation;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.operation.LPColourMultiplier;
import logisticspipes.proxy.object3d.operation.LPRotation;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.proxy.object3d.operation.LPUVTransformationList;
import logisticspipes.proxy.object3d.operation.LPUVTranslation;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.renderer.newpipe.RenderEntry;
import net.minecraft.util.ResourceLocation;

public final class SpeedupTubeRenderer
implements ISpecialPipeRenderer,
IHighlightPlacementRenderer {
    public static final SpeedupTubeRenderer instance = new SpeedupTubeRenderer();
    static Map<HSTubeSpeedup.SpeedupDirection, List<IModel3D>> tubeSpeedupBase = new HashMap<HSTubeSpeedup.SpeedupDirection, List<IModel3D>>();
    public static Map<HSTubeSpeedup.SpeedupDirection, IModel3D> tubeSpeedup = new HashMap<HSTubeSpeedup.SpeedupDirection, IModel3D>();
    private static final ResourceLocation TEXTURE = new ResourceLocation("logisticspipes", "textures/blocks/pipes/HS-Speedup.png");

    private SpeedupTubeRenderer() {
    }

    public static void loadModels() {
        try {
            Map<String, IModel3D> pipePartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/HSTube-Speedup_result.obj"), 7, new LPScale(0.01f));
            for (HSTubeSpeedup.SpeedupDirection turn : HSTubeSpeedup.SpeedupDirection.values()) {
                tubeSpeedupBase.put(turn, new ArrayList());
            }
            pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("Side ") || ((String)entry.getKey()).contains(" Side ") || ((String)entry.getKey()).endsWith(" Side")).forEach(entry -> {
                tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.EAST).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(0.0, 0.0, 0.0)).apply(new LPRotation(-1.5707963267948966, 0, 1, 0))));
                tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.NORTH).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.WEST).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(-1.0, 0.0, 1.0)).apply(new LPRotation(1.5707963267948966, 0, 1, 0))));
                tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.SOUTH).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPTranslation(-1.0, 0.0, 0.0)).apply(new LPRotation(Math.PI, 0, 1, 0))));
            });
            if (tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.NORTH).size() != 4) {
                throw new RuntimeException("Couldn't load Tube Side. Only loaded " + tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.NORTH).size());
            }
            for (HSTubeSpeedup.SpeedupDirection turn : HSTubeSpeedup.SpeedupDirection.values()) {
                tubeSpeedup.put(turn, SimpleServiceLocator.cclProxy.combine((Collection<IModel3D>)tubeSpeedupBase.get(turn)));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void renderToList(CoreUnroutedPipe pipe, List<RenderEntry> objectsToRender) {
        HSTubeSpeedup tube;
        if (pipe instanceof HSTubeSpeedup && (tube = (HSTubeSpeedup)pipe).getOrientation() != null) {
            HSTubeSpeedup.SpeedupDirection speedupDirection = (HSTubeSpeedup.SpeedupDirection)tube.getOrientation().getRenderOrientation();
            objectsToRender.addAll(tubeSpeedupBase.get(speedupDirection).stream().map(model -> new RenderEntry((IModel3D)model, new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.0f))}, TEXTURE)).collect(Collectors.toList()));
        }
        if (pipe == null) {
            objectsToRender.addAll(tubeSpeedupBase.get(HSTubeSpeedup.SpeedupDirection.NORTH).stream().map(model -> new RenderEntry((IModel3D)model, new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.0f))}, TEXTURE)).collect(Collectors.toList()));
        }
    }

    @Override
    public void renderHighlight(ITubeOrientation orientation) {
        HSTubeSpeedup.SpeedupDirection speedupDirection = (HSTubeSpeedup.SpeedupDirection)orientation.getRenderOrientation();
        tubeSpeedup.get(speedupDirection).copy().render(LPColourMultiplier.instance(-1));
        LogisticsNewRenderPipe.renderBoxWithDir(((HSTubeSpeedup.SpeedupDirection)orientation.getRenderOrientation()).getDir1());
    }

    static {
        SpeedupTubeRenderer.loadModels();
    }
}

