/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import logisticspipes.LPConstants;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.asm.te.ILPTEInformation;
import logisticspipes.asm.te.ITileEntityChangeListener;
import logisticspipes.asm.te.LPTileEntityObject;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.IRoutingDebugAdapter;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeItemsFirewall;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.DummyRoutingDebugAdapter;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.IRouterQueuedTask;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.routing.pathfinder.PathFinder;
import logisticspipes.ticks.LPTickHandler;
import logisticspipes.ticks.RoutingTableUpdateThread;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.OneList;
import logisticspipes.utils.StackTraceUtil;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Quartet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class ServerRouter
implements IRouter,
Comparable<ServerRouter> {
    static HashMap<ItemIdentifier, Set<IRouter>> _globalSpecificInterests = new HashMap();
    static Set<IRouter> _genericInterests = new TreeSet<IRouter>();
    Set<ItemIdentifier> _hasInterestIn = new TreeSet<ItemIdentifier>();
    boolean _hasGenericInterest;
    static final int REFRESH_TIME = 20;
    static int iterated = 0;
    int ticksUntillNextInventoryCheck = 0;
    private static int maxLSAUpdateIndex = 0;
    public Map<CoreRoutedPipe, ExitRoute> _adjacent = new HashMap<CoreRoutedPipe, ExitRoute>();
    public Map<IRouter, ExitRoute> _adjacentRouter = new HashMap<IRouter, ExitRoute>();
    public Map<IRouter, ExitRoute> _adjacentRouter_Old = new HashMap<IRouter, ExitRoute>();
    public List<Pair<ILogisticsPowerProvider, List<IFilter>>> _powerAdjacent = new ArrayList<Pair<ILogisticsPowerProvider, List<IFilter>>>();
    public List<Pair<ISubSystemPowerProvider, List<IFilter>>> _subSystemPowerAdjacent = new ArrayList<Pair<ISubSystemPowerProvider, List<IFilter>>>();
    public boolean[] sideDisconnected = new boolean[6];
    protected static int[] _lastLSAVersion = new int[0];
    protected int _LSAVersion = 0;
    protected final LSA _myLsa;
    protected UpdateRouterRunnable updateThread = null;
    protected static final ReentrantReadWriteLock SharedLSADatabaseLock = new ReentrantReadWriteLock();
    protected static final Lock SharedLSADatabasereadLock = SharedLSADatabaseLock.readLock();
    protected static final Lock SharedLSADatabasewriteLock = SharedLSADatabaseLock.writeLock();
    protected final ReentrantReadWriteLock routingTableUpdateLock = new ReentrantReadWriteLock();
    protected final Lock routingTableUpdateReadLock = this.routingTableUpdateLock.readLock();
    protected final Lock routingTableUpdateWriteLock = this.routingTableUpdateLock.writeLock();
    public Object _externalRoutersByCostLock = new Object();
    protected static LSA[] SharedLSADatabase = new LSA[0];
    public List<List<ExitRoute>> _routeTable = Collections.unmodifiableList(new ArrayList());
    public List<ExitRoute> _routeCosts = Collections.unmodifiableList(new ArrayList());
    public List<Pair<ILogisticsPowerProvider, List<IFilter>>> _LPPowerTable = Collections.unmodifiableList(new ArrayList());
    public List<Pair<ISubSystemPowerProvider, List<IFilter>>> _SubSystemPowerTable = Collections.unmodifiableList(new ArrayList());
    private EnumSet<EnumFacing> _routedExits = EnumSet.noneOf(EnumFacing.class);
    private EnumMap<EnumFacing, Integer> _subPowerExits = new EnumMap(EnumFacing.class);
    private static int firstFreeId = 1;
    private static BitSet simpleIdUsedSet = new BitSet();
    protected final int simpleID;
    public final UUID id;
    private int _dimension;
    private final int _xCoord;
    private final int _yCoord;
    private final int _zCoord;
    private boolean destroied = false;
    private WeakReference<CoreRoutedPipe> _myPipeCache = null;
    private LinkedList<Pair<Integer, IRouterQueuedTask>> queue = new LinkedList();
    private int connectionNeedsChecking = 0;
    private List<DoubleCoordinates> causedBy = new LinkedList<DoubleCoordinates>();
    private ITileEntityChangeListener localChangeListener = new ITileEntityChangeListener(){

        @Override
        public void pipeRemoved(DoubleCoordinates pos) {
            if (ServerRouter.this.connectionNeedsChecking == 0) {
                ServerRouter.this.connectionNeedsChecking = 1;
            }
            if (LPConstants.DEBUG) {
                ServerRouter.this.causedBy.add(pos);
            }
        }

        @Override
        public void pipeAdded(DoubleCoordinates pos, EnumFacing side) {
            if (ServerRouter.this.connectionNeedsChecking == 0) {
                ServerRouter.this.connectionNeedsChecking = 1;
            }
            if (LPConstants.DEBUG) {
                ServerRouter.this.causedBy.add(pos);
            }
        }

        @Override
        public void pipeModified(DoubleCoordinates pos) {
            if (ServerRouter.this.connectionNeedsChecking == 0) {
                ServerRouter.this.connectionNeedsChecking = 1;
            }
            if (LPConstants.DEBUG) {
                ServerRouter.this.causedBy.add(pos);
            }
        }
    };
    private Set<List<ITileEntityChangeListener>> listenedPipes = new HashSet<List<ITileEntityChangeListener>>();
    private Set<LPTileEntityObject> oldTouchedPipes = new HashSet<LPTileEntityObject>();

    public int hashCode() {
        return this.simpleID;
    }

    @Override
    public void clearPipeCache() {
        this._myPipeCache = null;
    }

    public static void cleanup() {
        _globalSpecificInterests.clear();
        _genericInterests.clear();
        SharedLSADatabasewriteLock.lock();
        SharedLSADatabase = new LSA[0];
        _lastLSAVersion = new int[0];
        SharedLSADatabasewriteLock.unlock();
        simpleIdUsedSet.clear();
        firstFreeId = 1;
    }

    private static int claimSimpleID() {
        int idx = simpleIdUsedSet.nextClearBit(firstFreeId);
        firstFreeId = idx + 1;
        simpleIdUsedSet.set(idx);
        return idx;
    }

    private static void releaseSimpleID(int idx) {
        simpleIdUsedSet.clear(idx);
        if (idx < firstFreeId) {
            firstFreeId = idx;
        }
    }

    public static int getBiggestSimpleID() {
        return simpleIdUsedSet.size();
    }

    public ServerRouter(UUID globalID, int dimension, int xCoord, int yCoord, int zCoord) {
        this.id = globalID != null ? globalID : UUID.randomUUID();
        this._dimension = dimension;
        this._xCoord = xCoord;
        this._yCoord = yCoord;
        this._zCoord = zCoord;
        this.clearPipeCache();
        this._myLsa = new LSA();
        this._myLsa.neighboursWithMetric = new HashMap();
        this._myLsa.power = new ArrayList<Pair<ILogisticsPowerProvider, List<IFilter>>>();
        SharedLSADatabasewriteLock.lock();
        this.simpleID = ServerRouter.claimSimpleID();
        if (SharedLSADatabase.length <= this.simpleID) {
            int newlength = (int)((double)this.simpleID * 1.5) + 1;
            LSA[] new_SharedLSADatabase = new LSA[newlength];
            System.arraycopy(SharedLSADatabase, 0, new_SharedLSADatabase, 0, SharedLSADatabase.length);
            SharedLSADatabase = new_SharedLSADatabase;
            int[] new_lastLSAVersion = new int[newlength];
            System.arraycopy(_lastLSAVersion, 0, new_lastLSAVersion, 0, _lastLSAVersion.length);
            _lastLSAVersion = new_lastLSAVersion;
        }
        ServerRouter._lastLSAVersion[this.simpleID] = 0;
        ServerRouter.SharedLSADatabase[this.simpleID] = this._myLsa;
        SharedLSADatabasewriteLock.unlock();
    }

    @Override
    public int getSimpleID() {
        return this.simpleID;
    }

    @Override
    public boolean isInDim(int dimension) {
        return this._dimension == dimension;
    }

    @Override
    public boolean isAt(int dimension, int xCoord, int yCoord, int zCoord) {
        return this._dimension == dimension && this._xCoord == xCoord && this._yCoord == yCoord && this._zCoord == zCoord;
    }

    @Override
    public DoubleCoordinates getLPPosition() {
        return new DoubleCoordinates(this._xCoord, this._yCoord, this._zCoord);
    }

    @Override
    public CoreRoutedPipe getPipe() {
        CoreRoutedPipe crp = this.getCachedPipe();
        if (crp != null) {
            return crp;
        }
        WorldServer world = DimensionManager.getWorld((int)this._dimension);
        if (world == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(new BlockPos(this._xCoord, this._yCoord, this._zCoord));
        if (!(tile instanceof LogisticsTileGenericPipe)) {
            return null;
        }
        LogisticsTileGenericPipe pipe = (LogisticsTileGenericPipe)tile;
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return null;
        }
        this._myPipeCache = new WeakReference<CoreRoutedPipe>((CoreRoutedPipe)pipe.pipe);
        return (CoreRoutedPipe)pipe.pipe;
    }

    @Override
    public CoreRoutedPipe getCachedPipe() {
        if (this._myPipeCache != null) {
            return (CoreRoutedPipe)this._myPipeCache.get();
        }
        return null;
    }

    @Override
    public boolean isValidCache() {
        return this.getPipe() != null;
    }

    private void ensureRouteTableIsUpToDate(boolean force) {
        boolean blockNeedsUpdate;
        if (force && this.connectionNeedsChecking != 0 && (blockNeedsUpdate = this.checkAdjacentUpdate())) {
            this.updateLsa();
        }
        if (this._LSAVersion > _lastLSAVersion[this.simpleID]) {
            if (Configs.MULTI_THREAD_NUMBER > 0 && !force) {
                RoutingTableUpdateThread.add(new UpdateRouterRunnable(this));
            } else {
                this.CreateRouteTable(this._LSAVersion);
            }
        }
    }

    @Override
    public List<List<ExitRoute>> getRouteTable() {
        this.ensureRouteTableIsUpToDate(true);
        return this._routeTable;
    }

    @Override
    public List<ExitRoute> getIRoutersByCost() {
        this.ensureRouteTableIsUpToDate(true);
        return this._routeCosts;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    private boolean recheckAdjacent() {
        this.connectionNeedsChecking = 0;
        if (LPConstants.DEBUG) {
            this.causedBy.clear();
        }
        if (this.getPipe() != null) {
            this.getPipe().spawnParticle(Particles.LightRedParticle, 5);
        }
        ++LPTickHandler.adjChecksDone;
        boolean adjacentChanged = false;
        CoreRoutedPipe thisPipe = this.getPipe();
        if (thisPipe == null) {
            return false;
        }
        PathFinder finder = new PathFinder((IPipeInformationProvider)thisPipe.container, Configs.LOGISTICS_DETECTION_COUNT, Configs.LOGISTICS_DETECTION_LENGTH, this.localChangeListener);
        List<Pair<ILogisticsPowerProvider, List<IFilter>>> power = finder.powerNodes;
        List<Pair<ISubSystemPowerProvider, List<IFilter>>> subSystemPower = finder.subPowerProvider;
        HashMap<CoreRoutedPipe, ExitRoute> adjacent = finder.result;
        HashMap<EnumFacing, List> pipeDirections = new HashMap<EnumFacing, List>();
        for (Map.Entry<CoreRoutedPipe, ExitRoute> entry2 : adjacent.entrySet()) {
            List list2 = pipeDirections.computeIfAbsent(entry2.getValue().exitOrientation, k -> new ArrayList());
            list2.add(entry2.getKey());
        }
        pipeDirections.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > Configs.MAX_UNROUTED_CONNECTIONS).forEach(entry -> ((List)entry.getValue()).forEach(adjacent::remove));
        this.listenedPipes.stream().filter(list -> !finder.listenedPipes.contains(list)).forEach(list -> list.remove(this.localChangeListener));
        this.listenedPipes = finder.listenedPipes;
        for (CoreRoutedPipe pipe : adjacent.keySet()) {
            if (!pipe.stillNeedReplace()) continue;
            return false;
        }
        boolean[] oldSideDisconnected = this.sideDisconnected;
        this.sideDisconnected = new boolean[6];
        this.checkSecurity(adjacent);
        boolean changed = false;
        for (int i = 0; i < 6; ++i) {
            changed |= this.sideDisconnected[i] != oldSideDisconnected[i];
        }
        if (changed) {
            CoreRoutedPipe pipe = this.getPipe();
            if (pipe != null) {
                pipe.getWorld().markAndNotifyBlock(pipe.getPos(), pipe.getWorld().func_175726_f(pipe.getPos()), pipe.getWorld().func_180495_p(pipe.getPos()), pipe.getWorld().func_180495_p(pipe.getPos()), 3);
                pipe.refreshConnectionAndRender(false);
            }
            adjacentChanged = true;
        }
        if (this._adjacent.size() != adjacent.size()) {
            adjacentChanged = true;
        }
        for (CoreRoutedPipe coreRoutedPipe : this._adjacent.keySet()) {
            if (adjacent.containsKey(coreRoutedPipe)) continue;
            adjacentChanged = true;
            break;
        }
        if (this._powerAdjacent != null) {
            if (power == null) {
                adjacentChanged = true;
            } else {
                for (Pair pair : this._powerAdjacent) {
                    if (power.contains(pair)) continue;
                    adjacentChanged = true;
                    break;
                }
            }
        }
        if (power != null) {
            if (this._powerAdjacent == null) {
                adjacentChanged = true;
            } else {
                for (Pair pair : power) {
                    if (this._powerAdjacent.contains(pair)) continue;
                    adjacentChanged = true;
                    break;
                }
            }
        }
        if (this._subSystemPowerAdjacent != null) {
            if (subSystemPower == null) {
                adjacentChanged = true;
            } else {
                for (Pair pair : this._subSystemPowerAdjacent) {
                    if (subSystemPower.contains(pair)) continue;
                    adjacentChanged = true;
                    break;
                }
            }
        }
        if (subSystemPower != null) {
            if (this._subSystemPowerAdjacent == null) {
                adjacentChanged = true;
            } else {
                for (Pair pair : subSystemPower) {
                    if (this._subSystemPowerAdjacent.contains(pair)) continue;
                    adjacentChanged = true;
                    break;
                }
            }
        }
        for (Map.Entry entry2 : adjacent.entrySet()) {
            ExitRoute oldExit = this._adjacent.get(entry2.getKey());
            if (oldExit == null) {
                adjacentChanged = true;
                break;
            }
            ExitRoute newExit = (ExitRoute)entry2.getValue();
            if (newExit.equals(oldExit)) continue;
            adjacentChanged = true;
            break;
        }
        if (!this.oldTouchedPipes.equals(finder.touchedPipes)) {
            CacheHolder.clearCache(this.oldTouchedPipes);
            CacheHolder.clearCache(finder.touchedPipes);
            this.oldTouchedPipes = finder.touchedPipes;
            BitSet visited = new BitSet(ServerRouter.getBiggestSimpleID());
            visited.set(this.getSimpleID());
            this.act(visited, new floodClearCache());
        }
        if (adjacentChanged) {
            HashMap<IRouter, ExitRoute> adjacentRouter = new HashMap<IRouter, ExitRoute>();
            EnumSet<EnumFacing> enumSet = EnumSet.noneOf(EnumFacing.class);
            EnumMap<EnumFacing, Integer> subpowerexits = new EnumMap<EnumFacing, Integer>(EnumFacing.class);
            for (Map.Entry<CoreRoutedPipe, ExitRoute> pipe : adjacent.entrySet()) {
                adjacentRouter.put(pipe.getKey().getRouter(), pipe.getValue());
                if (pipe.getValue().connectionDetails.contains((Object)PipeRoutingConnectionType.canRouteTo) || pipe.getValue().connectionDetails.contains((Object)PipeRoutingConnectionType.canRequestFrom) && !enumSet.contains(pipe.getValue().exitOrientation)) {
                    enumSet.add(pipe.getValue().exitOrientation);
                }
                if (subpowerexits.containsKey(pipe.getValue().exitOrientation) || !pipe.getValue().connectionDetails.contains((Object)PipeRoutingConnectionType.canPowerSubSystemFrom)) continue;
                subpowerexits.put(pipe.getValue().exitOrientation, PathFinder.messureDistanceToNextRoutedPipe(this.getLPPosition(), pipe.getValue().exitOrientation, pipe.getKey().getWorld()));
            }
            this._adjacent = Collections.unmodifiableMap(adjacent);
            this._adjacentRouter_Old = this._adjacentRouter;
            this._adjacentRouter = Collections.unmodifiableMap(adjacentRouter);
            this._powerAdjacent = power != null ? Collections.unmodifiableList(power) : null;
            this._subSystemPowerAdjacent = subSystemPower != null ? Collections.unmodifiableList(subSystemPower) : null;
            this._routedExits = enumSet;
            this._subPowerExits = subpowerexits;
            this.SendNewLSA();
        }
        return adjacentChanged;
    }

    private void checkSecurity(HashMap<CoreRoutedPipe, ExitRoute> adjacent) {
        CoreRoutedPipe pipe = this.getPipe();
        if (pipe == null) {
            return;
        }
        UUID id = pipe.getSecurityID();
        if (id != null) {
            for (Map.Entry<CoreRoutedPipe, ExitRoute> entry2 : adjacent.entrySet()) {
                if (!entry2.getValue().connectionDetails.contains((Object)PipeRoutingConnectionType.canRouteTo) && !entry2.getValue().connectionDetails.contains((Object)PipeRoutingConnectionType.canRequestFrom)) continue;
                UUID thatId = entry2.getKey().getSecurityID();
                if (!(pipe instanceof PipeItemsFirewall)) {
                    if (thatId == null) {
                        entry2.getKey().insetSecurityID(id);
                        continue;
                    }
                    if (id.equals(thatId)) continue;
                    this.sideDisconnected[entry2.getValue().exitOrientation.ordinal()] = true;
                    continue;
                }
                if (entry2.getKey() instanceof PipeItemsFirewall || thatId == null || id.equals(thatId)) continue;
                this.sideDisconnected[entry2.getValue().exitOrientation.ordinal()] = true;
            }
            List<CoreRoutedPipe> toRemove = adjacent.entrySet().stream().filter(entry -> this.sideDisconnected[((ExitRoute)entry.getValue()).exitOrientation.ordinal()]).map(Map.Entry::getKey).collect(Collectors.toList());
            toRemove.forEach(adjacent::remove);
        }
    }

    private void SendNewLSA() {
        HashMap<IRouter, Quartet<Double, EnumSet<PipeRoutingConnectionType>, List<IFilter>, Integer>> neighboursWithMetric = new HashMap<IRouter, Quartet<Double, EnumSet<PipeRoutingConnectionType>, List<IFilter>, Integer>>();
        for (Map.Entry<IRouter, ExitRoute> adjacent : this._adjacentRouter.entrySet()) {
            neighboursWithMetric.put(adjacent.getKey(), new Quartet<Double, EnumSet<PipeRoutingConnectionType>, List<IFilter>, Integer>(adjacent.getValue().distanceToDestination, adjacent.getValue().connectionDetails, adjacent.getValue().filters, adjacent.getValue().blockDistance));
        }
        ArrayList<Pair<ILogisticsPowerProvider, List<IFilter>>> power = null;
        if (this._powerAdjacent != null) {
            power = new ArrayList<Pair<ILogisticsPowerProvider, List<IFilter>>>(this._powerAdjacent);
        }
        ArrayList<Pair<ISubSystemPowerProvider, List<IFilter>>> subSystemPower = null;
        if (this._subSystemPowerAdjacent != null) {
            subSystemPower = new ArrayList<Pair<ISubSystemPowerProvider, List<IFilter>>>(this._subSystemPowerAdjacent);
        }
        if (Configs.MULTI_THREAD_NUMBER > 0) {
            RoutingTableUpdateThread.add(new LSARouterRunnable(neighboursWithMetric, power, subSystemPower));
        } else {
            this.lockAndUpdateLSA(neighboursWithMetric, power, subSystemPower);
        }
    }

    private void lockAndUpdateLSA(HashMap<IRouter, Quartet<Double, EnumSet<PipeRoutingConnectionType>, List<IFilter>, Integer>> neighboursWithMetric, ArrayList<Pair<ILogisticsPowerProvider, List<IFilter>>> power, ArrayList<Pair<ISubSystemPowerProvider, List<IFilter>>> subSystemPower) {
        SharedLSADatabasewriteLock.lock();
        this._myLsa.neighboursWithMetric = neighboursWithMetric;
        this._myLsa.power = power;
        this._myLsa.subSystemPower = subSystemPower;
        SharedLSADatabasewriteLock.unlock();
    }

    public void CreateRouteTable(int version_to_update_to) {
        this.CreateRouteTable(version_to_update_to, new DummyRoutingDebugAdapter());
    }

    /*
     * WARNING - void declaration
     */
    public void CreateRouteTable(int version_to_update_to, IRoutingDebugAdapter debug) {
        List<List<IFilter>> list;
        ExitRoute lowestCostNode;
        if (_lastLSAVersion[this.simpleID] >= version_to_update_to && !debug.independent()) {
            return;
        }
        debug.init();
        int routingTableSize = ServerRouter.getBiggestSimpleID();
        if (routingTableSize == 0) {
            routingTableSize = SharedLSADatabase.length;
        }
        ArrayList<ExitRoute> routeCosts = new ArrayList<ExitRoute>(routingTableSize);
        routeCosts.add(new ExitRoute((IRouter)this, (IRouter)this, null, null, 0.0, EnumSet.allOf(PipeRoutingConnectionType.class), 0));
        ArrayList<Object> powerTable = this._powerAdjacent != null ? new ArrayList<Pair<ILogisticsPowerProvider, List<IFilter>>>(this._powerAdjacent) : new ArrayList(5);
        ArrayList<Object> subSystemPower = this._subSystemPowerAdjacent != null ? new ArrayList<Pair<ISubSystemPowerProvider, List<IFilter>>>(this._subSystemPowerAdjacent) : new ArrayList(5);
        ArrayList<EnumSet<PipeRoutingConnectionType>> closedSet = new ArrayList<EnumSet<PipeRoutingConnectionType>>(ServerRouter.getBiggestSimpleID());
        for (int i = 0; i < ServerRouter.getBiggestSimpleID(); ++i) {
            closedSet.add(null);
        }
        ArrayList<EnumMap<PipeRoutingConnectionType, List<List<IFilter>>>> filterList = new ArrayList<EnumMap<PipeRoutingConnectionType, List<List<IFilter>>>>(ServerRouter.getBiggestSimpleID());
        for (int i = 0; i < ServerRouter.getBiggestSimpleID(); ++i) {
            filterList.add(null);
        }
        PriorityQueue<ExitRoute> candidatesCost = new PriorityQueue<ExitRoute>((int)Math.sqrt(routingTableSize));
        for (Map.Entry<IRouter, ExitRoute> entry : this._adjacentRouter.entrySet()) {
            ExitRoute currentE = entry.getValue();
            IRouter newRouter = entry.getKey();
            if (newRouter == null) continue;
            Iterator<Object> newER = new ExitRoute(newRouter, newRouter, currentE.distanceToDestination, currentE.connectionDetails, currentE.filters, new ArrayList<IFilter>(0), currentE.blockDistance);
            candidatesCost.add((ExitRoute)((Object)newER));
            debug.newCanidate((ExitRoute)((Object)newER));
        }
        debug.start(candidatesCost, closedSet, filterList);
        SharedLSADatabasereadLock.lock();
        while ((lowestCostNode = candidatesCost.poll()) != null) {
            EnumMap<PipeRoutingConnectionType, List<List<IFilter>>> map;
            void var11_18;
            if (!lowestCostNode.hasActivePipe()) continue;
            if (debug.isDebug()) {
                SharedLSADatabasereadLock.unlock();
            }
            debug.nextPipe(lowestCostNode);
            if (debug.isDebug()) {
                SharedLSADatabasereadLock.lock();
            }
            for (ExitRoute e : candidatesCost) {
                e.debug.isNewlyAddedCanidate = false;
            }
            EnumSet<PipeRoutingConnectionType> enumSet = closedSet.get(lowestCostNode.destination.getSimpleID());
            if (enumSet == null) {
                EnumSet<PipeRoutingConnectionType> enumSet2 = EnumSet.noneOf(PipeRoutingConnectionType.class);
            }
            if (var11_18.containsAll(lowestCostNode.getFlagsNoCopy())) continue;
            if (debug.isDebug()) {
                EnumSet<PipeRoutingConnectionType> newFlags = lowestCostNode.getFlags();
                newFlags.removeAll((Collection<?>)var11_18);
                debug.newFlagsForPipe(newFlags);
            }
            EnumMap<PipeRoutingConnectionType, List<List<IFilter>>> filters = filterList.get(lowestCostNode.destination.getSimpleID());
            debug.filterList(filters);
            if (filters != null) {
                boolean containsNewInfo = false;
                for (PipeRoutingConnectionType pipeRoutingConnectionType : lowestCostNode.getFlagsNoCopy()) {
                    if (var11_18.contains((Object)pipeRoutingConnectionType)) continue;
                    if (!filters.containsKey((Object)pipeRoutingConnectionType)) {
                        containsNewInfo = true;
                        break;
                    }
                    boolean matches = false;
                    list = filters.get((Object)pipeRoutingConnectionType);
                    for (List<IFilter> filter : list) {
                        if (!lowestCostNode.filters.containsAll(filter)) continue;
                        matches = true;
                        break;
                    }
                    if (matches) continue;
                    containsNewInfo = true;
                    break;
                }
                if (!containsNewInfo) continue;
            }
            LSA lsa = null;
            if (lowestCostNode.destination.getSimpleID() < SharedLSADatabase.length) {
                lsa = SharedLSADatabase[lowestCostNode.destination.getSimpleID()];
            }
            if (lsa == null) {
                lowestCostNode.removeFlags((EnumSet<PipeRoutingConnectionType>)var11_18);
                var11_18.addAll(lowestCostNode.getFlagsNoCopy());
                if (lowestCostNode.containsFlag(PipeRoutingConnectionType.canRouteTo) || lowestCostNode.containsFlag(PipeRoutingConnectionType.canRequestFrom)) {
                    routeCosts.add(lowestCostNode);
                }
                closedSet.set(lowestCostNode.destination.getSimpleID(), (EnumSet<PipeRoutingConnectionType>)var11_18);
                continue;
            }
            if (lowestCostNode.containsFlag(PipeRoutingConnectionType.canPowerFrom) && lsa.power != null && !lsa.power.isEmpty()) {
                for (Pair pair : lsa.power) {
                    Pair entry = pair.copy();
                    list = new ArrayList<List<IFilter>>();
                    list.addAll((Collection)pair.getValue2());
                    list.addAll(lowestCostNode.filters);
                    entry.setValue2(Collections.unmodifiableList(list));
                    if (powerTable.contains(entry)) continue;
                    powerTable.add(entry);
                }
            }
            if (lowestCostNode.containsFlag(PipeRoutingConnectionType.canPowerSubSystemFrom) && lsa.subSystemPower != null && !lsa.subSystemPower.isEmpty()) {
                for (Pair pair : lsa.subSystemPower) {
                    Pair entry = pair.copy();
                    list = new ArrayList<List<IFilter>>();
                    list.addAll((Collection)pair.getValue2());
                    list.addAll(lowestCostNode.filters);
                    entry.setValue2(Collections.unmodifiableList(list));
                    if (subSystemPower.contains(entry)) continue;
                    subSystemPower.add(entry);
                }
            }
            for (Map.Entry entry : lsa.neighboursWithMetric.entrySet()) {
                double candidateCost = lowestCostNode.distanceToDestination + (Double)((Quartet)entry.getValue()).getValue1();
                int blockDistance = lowestCostNode.blockDistance + (Integer)((Quartet)entry.getValue()).getValue4();
                EnumSet<PipeRoutingConnectionType> newCT = lowestCostNode.getFlags();
                newCT.retainAll((Collection)((Quartet)entry.getValue()).getValue2());
                if (newCT.isEmpty()) continue;
                ExitRoute next = new ExitRoute(lowestCostNode.root, (IRouter)entry.getKey(), candidateCost, newCT, lowestCostNode.filters, (List)((Quartet)entry.getValue()).getValue3(), blockDistance);
                next.debug.isTraced = lowestCostNode.debug.isTraced;
                candidatesCost.add(next);
                debug.newCanidate(next);
            }
            Object object = var11_18.clone();
            lowestCostNode.removeFlags((EnumSet<PipeRoutingConnectionType>)object);
            ((AbstractCollection)object).addAll(lowestCostNode.getFlagsNoCopy());
            if (lowestCostNode.containsFlag(PipeRoutingConnectionType.canRouteTo) || lowestCostNode.containsFlag(PipeRoutingConnectionType.canRequestFrom) || lowestCostNode.containsFlag(PipeRoutingConnectionType.canPowerSubSystemFrom)) {
                routeCosts.add(lowestCostNode);
            }
            if ((map = filterList.get(lowestCostNode.destination.getSimpleID())) == null) {
                map = new EnumMap(PipeRoutingConnectionType.class);
                filterList.set(lowestCostNode.destination.getSimpleID(), map);
            }
            for (PipeRoutingConnectionType type : lowestCostNode.getFlagsNoCopy()) {
                if (!map.containsKey((Object)type)) {
                    map.put(type, new ArrayList());
                }
                map.get((Object)type).add(Collections.unmodifiableList(new ArrayList<IFilter>(lowestCostNode.filters)));
            }
            if (lowestCostNode.filters.isEmpty()) {
                closedSet.set(lowestCostNode.destination.getSimpleID(), (EnumSet<PipeRoutingConnectionType>)object);
            }
            if (debug.isDebug()) {
                SharedLSADatabasereadLock.unlock();
            }
            debug.handledPipe();
            if (!debug.isDebug()) continue;
            SharedLSADatabasereadLock.lock();
        }
        SharedLSADatabasereadLock.unlock();
        debug.stepOneDone();
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>(ServerRouter.getBiggestSimpleID() + 1);
        while (this.simpleID >= arrayList.size()) {
            arrayList.add(null);
        }
        arrayList.set(this.simpleID, new OneList<ExitRoute>(new ExitRoute((IRouter)this, (IRouter)this, null, null, 0.0, EnumSet.allOf(PipeRoutingConnectionType.class), 0)));
        for (ExitRoute node : routeCosts) {
            IRouter firstHop = node.root;
            ExitRoute exitRoute = this._adjacentRouter.get(firstHop);
            if (exitRoute == null) continue;
            node.root = this;
            node.exitOrientation = exitRoute.exitOrientation;
            while (node.destination.getSimpleID() >= arrayList.size()) {
                arrayList.add(null);
            }
            List current = (List)arrayList.get(node.destination.getSimpleID());
            if (current != null && !current.isEmpty()) {
                list = new ArrayList<List<IFilter>>(current);
                list.add((List<IFilter>)((Object)node));
                arrayList.set(node.destination.getSimpleID(), Collections.unmodifiableList(list));
                continue;
            }
            arrayList.set(node.destination.getSimpleID(), new OneList<ExitRoute>(node));
        }
        debug.stepTwoDone();
        if (!debug.independent()) {
            this.routingTableUpdateWriteLock.lock();
            if (version_to_update_to == this._LSAVersion) {
                SharedLSADatabasereadLock.lock();
                if (_lastLSAVersion[this.simpleID] < version_to_update_to) {
                    ServerRouter._lastLSAVersion[this.simpleID] = version_to_update_to;
                    this._LPPowerTable = Collections.unmodifiableList(powerTable);
                    this._SubSystemPowerTable = Collections.unmodifiableList(subSystemPower);
                    this._routeTable = Collections.unmodifiableList(arrayList);
                    this._routeCosts = Collections.unmodifiableList(routeCosts);
                }
                SharedLSADatabasereadLock.unlock();
            }
            this.routingTableUpdateWriteLock.unlock();
        }
        if (this.getCachedPipe() != null) {
            this.getCachedPipe().spawnParticle(Particles.LightGreenParticle, 5);
        }
        debug.done();
    }

    @Override
    public void act(BitSet hasBeenProcessed, IRouter.IRAction actor) {
        if (hasBeenProcessed.get(this.simpleID)) {
            return;
        }
        hasBeenProcessed.set(this.simpleID);
        if (!actor.isInteresting(this)) {
            return;
        }
        actor.doTo(this);
        for (IRouter r : this._adjacentRouter.keySet()) {
            r.act(hasBeenProcessed, actor);
        }
    }

    @Override
    public void destroy() {
        SharedLSADatabasewriteLock.lock();
        if (this.simpleID < SharedLSADatabase.length) {
            ServerRouter.SharedLSADatabase[this.simpleID] = null;
        }
        SharedLSADatabasewriteLock.unlock();
        this.removeAllInterests();
        this.clearPipeCache();
        this.setDestroied(true);
        SimpleServiceLocator.routerManager.removeRouter(this.simpleID);
        for (List<ITileEntityChangeListener> list : this.listenedPipes) {
            list.remove(this.localChangeListener);
        }
        this.updateAdjacentAndLsa();
        ServerRouter.releaseSimpleID(this.simpleID);
    }

    private void removeAllInterests() {
        this.removeGenericInterest();
        this._hasInterestIn.forEach(this::removeInterest);
        this._hasInterestIn.clear();
    }

    @Override
    public boolean checkAdjacentUpdate() {
        boolean blockNeedsUpdate = this.recheckAdjacent();
        if (!blockNeedsUpdate) {
            return false;
        }
        CoreRoutedPipe pipe = this.getPipe();
        if (pipe == null) {
            return true;
        }
        pipe.refreshRender(true);
        return true;
    }

    @Override
    public void flagForRoutingUpdate() {
        ++this._LSAVersion;
    }

    private void updateAdjacentAndLsa() {
        BitSet visited = new BitSet(ServerRouter.getBiggestSimpleID());
        floodCheckAdjacent flood = new floodCheckAdjacent();
        visited.set(this.simpleID);
        for (IRouter r : this._adjacentRouter_Old.keySet()) {
            r.act(visited, flood);
        }
        for (IRouter r : this._adjacentRouter.keySet()) {
            r.act(visited, flood);
        }
        this.updateLsa();
    }

    private void updateLsa() {
        BitSet visited = new BitSet(ServerRouter.getBiggestSimpleID());
        for (IRouter r : this._adjacentRouter_Old.keySet()) {
            r.act(visited, new flagForLSAUpdate());
        }
        this._adjacentRouter_Old = new HashMap<IRouter, ExitRoute>();
        this.act(visited, new flagForLSAUpdate());
    }

    @Override
    public void update(boolean doFullRefresh, CoreRoutedPipe pipe) {
        if (this.connectionNeedsChecking == 2) {
            this.ensureChangeListenerAttachedToPipe(pipe);
            StackTraceUtil.Info info = StackTraceUtil.addTraceInformation(this.causedBy::toString, new StackTraceUtil.Info[0]);
            boolean blockNeedsUpdate = this.checkAdjacentUpdate();
            if (blockNeedsUpdate) {
                this.updateLsa();
            }
            info.end();
            this.ensureChangeListenerAttachedToPipe(pipe);
        }
        if (this.connectionNeedsChecking == 1) {
            this.connectionNeedsChecking = 2;
        }
        this.handleQueuedTasks(pipe);
        this.updateInterests();
        if (doFullRefresh) {
            this.ensureChangeListenerAttachedToPipe(pipe);
            boolean blockNeedsUpdate = this.checkAdjacentUpdate();
            if (blockNeedsUpdate) {
                this.updateLsa();
            }
            this.ensureChangeListenerAttachedToPipe(pipe);
            this.ensureRouteTableIsUpToDate(false);
            return;
        }
        if (Configs.MULTI_THREAD_NUMBER > 0) {
            this.ensureRouteTableIsUpToDate(false);
        }
    }

    private void ensureChangeListenerAttachedToPipe(CoreRoutedPipe pipe) {
        if (pipe.container instanceof ILPTEInformation && ((ILPTEInformation)((Object)pipe.container)).getObject() != null && !((ILPTEInformation)((Object)pipe.container)).getObject().changeListeners.contains(this.localChangeListener)) {
            ((ILPTEInformation)((Object)pipe.container)).getObject().changeListeners.add(this.localChangeListener);
        }
    }

    private void handleQueuedTasks(CoreRoutedPipe pipe) {
        while (!this.queue.isEmpty()) {
            Pair<Integer, IRouterQueuedTask> element = this.queue.poll();
            if (element.getValue1() <= MainProxy.getGlobalTick()) continue;
            element.getValue2().call(pipe, this);
        }
    }

    @Override
    public boolean isRoutedExit(EnumFacing o) {
        return this._routedExits.contains(o);
    }

    @Override
    public boolean isSubPoweredExit(EnumFacing o) {
        return this._subPowerExits.containsKey(o);
    }

    @Override
    public int getDistanceToNextPowerPipe(EnumFacing dir) {
        return this._subPowerExits.get(dir);
    }

    @Override
    public ExitRoute getExitFor(int id, boolean active, ItemIdentifier type) {
        this.ensureRouteTableIsUpToDate(true);
        if (this.getRouteTable().size() <= id || this.getRouteTable().get(id) == null) {
            return null;
        }
        block0: for (ExitRoute exit : this.getRouteTable().get(id)) {
            if (!exit.containsFlag(PipeRoutingConnectionType.canRouteTo)) continue;
            for (IFilter filter : exit.filters) {
                if (!(!active ? filter.blockRouting() || filter.isBlocked() == filter.isFilteredItem(type) : filter.blockProvider() && filter.blockCrafting() || filter.isBlocked() == filter.isFilteredItem(type))) continue;
                continue block0;
            }
            return exit;
        }
        return null;
    }

    @Override
    public boolean hasRoute(int id, boolean active, ItemIdentifier type) {
        if (!SimpleServiceLocator.routerManager.isRouterUnsafe(id, false)) {
            return false;
        }
        this.ensureRouteTableIsUpToDate(true);
        if (this.getRouteTable().size() <= id) {
            return false;
        }
        List<ExitRoute> source = this.getRouteTable().get(id);
        if (source == null) {
            return false;
        }
        block0: for (ExitRoute exit : source) {
            if (!exit.containsFlag(PipeRoutingConnectionType.canRouteTo)) continue;
            for (IFilter filter : exit.filters) {
                if (!(!active ? filter.blockRouting() || filter.isBlocked() == filter.isFilteredItem(type) : filter.blockProvider() && filter.blockCrafting() || filter.isBlocked() == filter.isFilteredItem(type))) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        CoreRoutedPipe pipe = this.getPipe();
        if (pipe == null) {
            return null;
        }
        return pipe.getLogisticsModule();
    }

    @Override
    public List<Pair<ILogisticsPowerProvider, List<IFilter>>> getPowerProvider() {
        return this._LPPowerTable;
    }

    @Override
    public List<Pair<ISubSystemPowerProvider, List<IFilter>>> getSubSystemPowerProvider() {
        return this._SubSystemPowerTable;
    }

    @Override
    public boolean isSideDisconnected(EnumFacing dir) {
        return null != dir && this.sideDisconnected[dir.ordinal()];
    }

    @Override
    public void updateInterests() {
        CoreRoutedPipe pipe;
        if (--this.ticksUntillNextInventoryCheck > 0) {
            return;
        }
        this.ticksUntillNextInventoryCheck = 20;
        if (iterated++ % this.simpleID == 0) {
            ++this.ticksUntillNextInventoryCheck;
        }
        if (iterated >= ServerRouter.getBiggestSimpleID()) {
            iterated = 0;
        }
        if ((pipe = this.getPipe()) == null) {
            return;
        }
        if (pipe.hasGenericInterests()) {
            this.declareGenericInterest();
        } else {
            this.removeGenericInterest();
        }
        Set<ItemIdentifier> newInterests = pipe.getSpecificInterests();
        if (newInterests == null) {
            newInterests = new TreeSet<ItemIdentifier>();
        }
        if (!newInterests.equals(this._hasInterestIn)) {
            for (ItemIdentifier i2 : this._hasInterestIn) {
                if (newInterests.contains(i2)) continue;
                this.removeInterest(i2);
            }
            newInterests.stream().filter(i -> !this._hasInterestIn.contains(i)).forEach(this::addInterest);
            this._hasInterestIn = newInterests;
        }
    }

    private void removeGenericInterest() {
        this._hasGenericInterest = false;
        _genericInterests.remove(this);
    }

    private void declareGenericInterest() {
        this._hasGenericInterest = true;
        _genericInterests.add(this);
    }

    private void addInterest(ItemIdentifier items) {
        Set<IRouter> interests = _globalSpecificInterests.get(items);
        if (interests == null) {
            interests = new TreeSet<IRouter>();
            _globalSpecificInterests.put(items, interests);
        }
        interests.add(this);
    }

    private void removeInterest(ItemIdentifier p2) {
        Set<IRouter> interests = _globalSpecificInterests.get(p2);
        if (interests == null) {
            return;
        }
        interests.remove(this);
        if (interests.isEmpty()) {
            _globalSpecificInterests.remove(p2);
        }
    }

    public boolean hasGenericInterest() {
        return this._hasGenericInterest;
    }

    public boolean hasInterestIn(ItemIdentifier item) {
        return this._hasInterestIn.contains(item);
    }

    public static BitSet getRoutersInterestedIn(ItemIdentifier item) {
        BitSet s = new BitSet(ServerRouter.getBiggestSimpleID() + 1);
        if (_genericInterests != null) {
            for (IRouter r : _genericInterests) {
                s.set(r.getSimpleID());
            }
        }
        if (item == null) {
            return s;
        }
        Set<IRouter> specifics = _globalSpecificInterests.get(item);
        if (specifics != null) {
            for (IRouter r : specifics) {
                s.set(r.getSimpleID());
            }
        }
        if ((specifics = _globalSpecificInterests.get(item.getUndamaged())) != null) {
            for (IRouter r : specifics) {
                s.set(r.getSimpleID());
            }
        }
        if ((specifics = _globalSpecificInterests.get(item.getIgnoringNBT())) != null) {
            for (IRouter r : specifics) {
                s.set(r.getSimpleID());
            }
        }
        if ((specifics = _globalSpecificInterests.get(item.getUndamaged().getIgnoringNBT())) != null) {
            for (IRouter r : specifics) {
                s.set(r.getSimpleID());
            }
        }
        if ((specifics = _globalSpecificInterests.get(item.getIgnoringData())) != null) {
            for (IRouter r : specifics) {
                s.set(r.getSimpleID());
            }
        }
        if ((specifics = _globalSpecificInterests.get(item.getIgnoringData().getIgnoringNBT())) != null) {
            for (IRouter r : specifics) {
                s.set(r.getSimpleID());
            }
        }
        return s;
    }

    public static BitSet getRoutersInterestedIn(IResource item) {
        if (item instanceof ItemResource) {
            return ServerRouter.getRoutersInterestedIn(((ItemResource)item).getItem());
        }
        if (item instanceof FluidResource) {
            return ServerRouter.getRoutersInterestedIn(((FluidResource)item).getFluid().getItemIdentifier());
        }
        if (item instanceof DictResource) {
            DictResource dict = (DictResource)item;
            BitSet s = new BitSet(ServerRouter.getBiggestSimpleID() + 1);
            if (_genericInterests != null) {
                for (IRouter r : _genericInterests) {
                    s.set(r.getSimpleID());
                }
            }
            _globalSpecificInterests.entrySet().stream().filter(entry -> dict.matches((ItemIdentifier)entry.getKey(), IResource.MatchSettings.NORMAL)).forEach(entry -> {
                for (IRouter r : (Set)entry.getValue()) {
                    s.set(r.getSimpleID());
                }
            });
            return s;
        }
        return new BitSet(ServerRouter.getBiggestSimpleID() + 1);
    }

    @Override
    public int compareTo(ServerRouter o) {
        return this.simpleID - o.simpleID;
    }

    @Override
    public List<ExitRoute> getDistanceTo(IRouter r) {
        this.ensureRouteTableIsUpToDate(true);
        int id = r.getSimpleID();
        if (this._routeTable.size() <= id) {
            return new ArrayList<ExitRoute>(0);
        }
        ArrayList result = this._routeTable.get(id);
        return result != null ? result : new ArrayList(0);
    }

    public static Map<ItemIdentifier, Set<IRouter>> getInterestedInSpecifics() {
        return _globalSpecificInterests;
    }

    public static Set<IRouter> getInterestedInGeneral() {
        return _genericInterests;
    }

    @Override
    public void clearInterests() {
        this.removeAllInterests();
    }

    public String toString() {
        return String.format("ServerRouter: {ID: %d, UUID: %s, AT: (%d, %d, %d, %d), Version: %d), Destroyed: %s}", this.simpleID, this.getId(), this._dimension, this._xCoord, this._yCoord, this._zCoord, this._LSAVersion, this.isDestroied());
    }

    @Override
    public void forceLsaUpdate() {
        BitSet visited = new BitSet(ServerRouter.getBiggestSimpleID());
        this.act(visited, new flagForLSAUpdate());
    }

    @Override
    public List<ExitRoute> getRoutersOnSide(EnumFacing direction) {
        return this._adjacentRouter.values().stream().filter(exit -> exit.exitOrientation == direction).collect(Collectors.toList());
    }

    @Override
    public int getDimension() {
        return this._dimension;
    }

    @Override
    public void queueTask(int i, IRouterQueuedTask callable) {
        this.queue.add(new Pair<Integer, IRouterQueuedTask>(i + MainProxy.getGlobalTick(), callable));
    }

    public int get_xCoord() {
        return this._xCoord;
    }

    public int get_yCoord() {
        return this._yCoord;
    }

    public int get_zCoord() {
        return this._zCoord;
    }

    public boolean isDestroied() {
        return this.destroied;
    }

    private ServerRouter setDestroied(boolean destroied) {
        this.destroied = destroied;
        return this;
    }

    static class floodClearCache
    implements IRouter.IRAction {
        floodClearCache() {
        }

        @Override
        public boolean isInteresting(IRouter that) {
            return true;
        }

        @Override
        public void doTo(IRouter that) {
            CacheHolder.clearCache(((ServerRouter)that).oldTouchedPipes);
        }
    }

    static class flagForLSAUpdate
    implements IRouter.IRAction {
        flagForLSAUpdate() {
        }

        @Override
        public boolean isInteresting(IRouter that) {
            return true;
        }

        @Override
        public void doTo(IRouter that) {
            that.flagForRoutingUpdate();
        }
    }

    static class floodCheckAdjacent
    implements IRouter.IRAction {
        floodCheckAdjacent() {
        }

        @Override
        public boolean isInteresting(IRouter that) {
            return that.checkAdjacentUpdate();
        }

        @Override
        public void doTo(IRouter that) {
        }
    }

    private class LSARouterRunnable
    extends RouterRunnable {
        private final int index;
        HashMap<IRouter, Quartet<Double, EnumSet<PipeRoutingConnectionType>, List<IFilter>, Integer>> neighboursWithMetric;
        ArrayList<Pair<ILogisticsPowerProvider, List<IFilter>>> power;
        ArrayList<Pair<ISubSystemPowerProvider, List<IFilter>>> subSystemPower;

        LSARouterRunnable(HashMap<IRouter, Quartet<Double, EnumSet<PipeRoutingConnectionType>, List<IFilter>, Integer>> neighboursWithMetric, ArrayList<Pair<ILogisticsPowerProvider, List<IFilter>>> power, ArrayList<Pair<ISubSystemPowerProvider, List<IFilter>>> subSystemPower) {
            this.index = maxLSAUpdateIndex++;
            this.neighboursWithMetric = neighboursWithMetric;
            this.power = power;
            this.subSystemPower = subSystemPower;
        }

        @Override
        public void run() {
            ServerRouter.this.lockAndUpdateLSA(this.neighboursWithMetric, this.power, this.subSystemPower);
        }

        @Override
        public int getPrority() {
            return 1;
        }

        @Override
        public int localCompare(RouterRunnable o) {
            return this.index - ((LSARouterRunnable)o).index;
        }
    }

    private class UpdateRouterRunnable
    extends RouterRunnable {
        int newVersion;
        boolean run;
        IRouter target;

        UpdateRouterRunnable(IRouter target) {
            this.run = true;
            this.newVersion = ServerRouter.this._LSAVersion;
            this.target = target;
        }

        @Override
        public void run() {
            if (!this.run) {
                return;
            }
            try {
                CoreRoutedPipe p = this.target.getCachedPipe();
                if (p == null) {
                    this.run = false;
                    return;
                }
                for (int i = 0; i < 10 && p.stillNeedReplace(); ++i) {
                    Thread.sleep(10L);
                }
                if (p.stillNeedReplace()) {
                    return;
                }
                ServerRouter.this.CreateRouteTable(this.newVersion);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.run = false;
        }

        @Override
        public int getPrority() {
            return 0;
        }

        @Override
        public int localCompare(RouterRunnable o) {
            int c = 0;
            if (((UpdateRouterRunnable)o).newVersion <= 0) {
                c = this.newVersion - ((UpdateRouterRunnable)o).newVersion;
            }
            if (c != 0) {
                return 0;
            }
            c = this.target.getSimpleID() - ((UpdateRouterRunnable)o).target.getSimpleID();
            if (c != 0) {
                return 0;
            }
            c = ((UpdateRouterRunnable)o).newVersion - this.newVersion;
            return c;
        }
    }

    private static abstract class RouterRunnable
    implements Comparable<RouterRunnable>,
    Runnable {
        private RouterRunnable() {
        }

        public abstract int getPrority();

        public abstract int localCompare(RouterRunnable var1);

        @Override
        public int compareTo(RouterRunnable o) {
            if (o.getPrority() == this.getPrority()) {
                return this.localCompare(o);
            }
            return o.getPrority() - this.getPrority();
        }
    }

    protected static class LSA {
        public HashMap<IRouter, Quartet<Double, EnumSet<PipeRoutingConnectionType>, List<IFilter>, Integer>> neighboursWithMetric;
        public List<Pair<ILogisticsPowerProvider, List<IFilter>>> power;
        public ArrayList<Pair<ISubSystemPowerProvider, List<IFilter>>> subSystemPower;

        protected LSA() {
        }
    }
}

