/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.recipe.RecipeTypeProcessing;
import thelm.packagedauto.util.PatternHelper;

public class RecipeInfoProcessing
implements IRecipeInfo {
    List<ItemStack> input = new ArrayList<ItemStack>();
    List<ItemStack> output = new ArrayList<ItemStack>();
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        MiscUtil.loadAllItems(nbt.func_150295_c("Input", 10), this.input);
        MiscUtil.loadAllItems(nbt.func_150295_c("Output", 10), this.output);
        this.patterns.clear();
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PatternHelper(this, i));
            ++i;
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList inputTag = MiscUtil.saveAllItems(new NBTTagList(), this.input);
        nbt.func_74782_a("Input", (NBTBase)inputTag);
        NBTTagList outputTag = MiscUtil.saveAllItems(new NBTTagList(), this.output);
        nbt.func_74782_a("Output", (NBTBase)outputTag);
        return nbt;
    }

    @Override
    public IRecipeType getRecipeType() {
        return RecipeTypeProcessing.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return !this.input.isEmpty();
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return Collections.unmodifiableList(this.output);
    }

    @Override
    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        this.input.clear();
        this.input.addAll(MiscUtil.condenseStacks(input));
        this.output.clear();
        this.output.addAll(MiscUtil.condenseStacks(output));
        this.patterns.clear();
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PatternHelper(this, i));
            ++i;
        }
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        int i;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (i = 0; i < this.input.size(); ++i) {
            map.put(i, (Object)this.input.get(i));
        }
        for (i = 0; i < this.output.size(); ++i) {
            map.put(i + 81, (Object)this.output.get(i));
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RecipeInfoProcessing) {
            int i;
            RecipeInfoProcessing other = (RecipeInfoProcessing)obj;
            if (this.input.size() != other.input.size() || this.output.size() != other.output.size()) {
                return false;
            }
            for (i = 0; i < this.input.size(); ++i) {
                if (ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)this.input.get(i), (ItemStack)other.input.get(i))) continue;
                return false;
            }
            for (i = 0; i < this.output.size(); ++i) {
                if (ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)this.output.get(i), (ItemStack)other.output.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        Object[] toHash = new Object[2];
        Object[] inputArray = new Object[this.input.size()];
        for (int i = 0; i < this.input.size(); ++i) {
            ItemStack stack = this.input.get(i);
            inputArray[i] = new Object[]{stack.func_77973_b(), stack.func_77952_i(), stack.func_190916_E(), stack.func_77978_p()};
        }
        Object[] outputArray = new Object[this.output.size()];
        for (int i = 0; i < this.output.size(); ++i) {
            ItemStack stack = this.output.get(i);
            outputArray[i] = new Object[]{stack.func_77973_b(), stack.func_77952_i(), stack.func_190916_E(), stack.func_77978_p()};
        }
        toHash[0] = inputArray;
        toHash[1] = outputArray;
        return Arrays.deepHashCode(toHash);
    }
}

