/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.client.gui;

import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import xt9.deepmoblearning.common.config.Config;
import xt9.deepmoblearning.common.items.ItemDeepLearner;
import xt9.deepmoblearning.common.util.DataModel;
import xt9.deepmoblearning.common.util.PlayerHelper;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class DataOverlay
extends GuiScreen {
    private final FontRenderer renderer;
    private Minecraft mc;
    private ItemStack deepLearner;
    private NonNullList<ItemStack> dataModels;
    private PlayerHelper playerH;
    private int componentHeight = 26;
    private int barSpacing = 12;
    private static final ResourceLocation experienceBar = new ResourceLocation("deepmoblearning", "textures/gui/experience_gui.png");

    public DataOverlay(Minecraft mc) {
        this.mc = mc;
        this.renderer = this.mc.field_71466_p;
        this.field_146296_j = this.mc.func_175599_af();
        this.func_183500_a(89, 12);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        String position;
        if (event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (!this.mc.field_71415_G) {
            return;
        }
        this.playerH = new PlayerHelper((EntityPlayer)this.mc.field_71439_g);
        if (!this.playerH.isHoldingDeepLearner()) {
            return;
        }
        this.deepLearner = this.playerH.getHeldDeepLearner();
        this.dataModels = DataModel.getValidFromList(ItemDeepLearner.getContainedItems(this.deepLearner));
        int x = Config.guiOverlayHorizontalSpacing.getInt();
        int y = Config.guiOverlayVerticalSpacing.getInt();
        switch (position = Config.guiOverlaySide.getString()) {
            case "topleft": {
                x = x + this.getLeftCornerX() + 18;
                y += 5;
                break;
            }
            case "topright": {
                x += this.getRightCornerX();
                y += 5;
                break;
            }
            case "bottomleft": {
                x = x + this.getLeftCornerX() + 18;
                y = y + this.getBottomY(this.dataModels.size()) - 5;
                break;
            }
            case "bottomright": {
                x += this.getRightCornerX();
                y = y + this.getBottomY(this.dataModels.size()) - 5;
                break;
            }
            default: {
                x = x + this.getLeftCornerX() + 18;
                y += 5;
            }
        }
        for (int i = 0; i < this.dataModels.size(); ++i) {
            ItemStack stack = (ItemStack)this.dataModels.get(i);
            String tierName = DataModel.getTierName(stack, false);
            int tier = DataModel.getTier(stack);
            double k = DataModel.getKillsToNextTier(stack);
            double c = DataModel.getCurrentTierKillCountWithSims(stack);
            int roof = DataModel.getTierRoofAsKills(stack);
            this.drawExperienceBar(x, y, i, tierName, tier, k, c, roof, stack);
        }
    }

    private void drawExperienceBar(int x, int y, int index, String tierName, int tier, double killsToNextTier, double currenKillCount, int tierRoof, ItemStack stack) {
        DecimalFormat f = new DecimalFormat("0.#");
        this.drawItemStack(x - 18, y - 2 + this.barSpacing + index * this.componentHeight, stack);
        this.func_73731_b(this.renderer, tierName + " Model", x - 14, y + index * this.componentHeight + 2, 0xFFFFFF);
        this.mc.func_110434_K().func_110577_a(experienceBar);
        this.func_73729_b(x, y + this.barSpacing + index * this.componentHeight, 0, 0, 89, 12);
        if (tier == 4) {
            this.func_73729_b(x + 1, y + 1 + this.barSpacing + index * this.componentHeight, 0, 12, 89, 11);
        } else {
            this.func_73729_b(x + 1, y + 1 + this.barSpacing + index * this.componentHeight, 0, 12, (int)((float)currenKillCount / (float)tierRoof * 89.0f), 11);
            this.func_73731_b(this.renderer, f.format(killsToNextTier) + " to go", x + 3, y + 2 + this.barSpacing + index * this.componentHeight, 0xFFFFFF);
        }
    }

    private int getLeftCornerX() {
        return 5;
    }

    private int getRightCornerX() {
        ScaledResolution scaledResolution = new ScaledResolution(this.mc);
        return scaledResolution.func_78326_a() - this.field_146294_l - 5;
    }

    private int getBottomY(int numberOfBars) {
        ScaledResolution scaledResolution = new ScaledResolution(this.mc);
        return scaledResolution.func_78328_b() - numberOfBars * this.componentHeight;
    }

    private void drawItemStack(int x, int y, ItemStack stack) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }
}

