/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.client.gui;

import java.io.IOException;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xt9.deepmoblearning.common.inventory.ContainerDeepLearner;
import xt9.deepmoblearning.common.items.ItemDeepLearner;
import xt9.deepmoblearning.common.mobmetas.MobMetaData;
import xt9.deepmoblearning.common.mobmetas.SpiderMeta;
import xt9.deepmoblearning.common.mobmetas.ZombieMeta;
import xt9.deepmoblearning.common.util.DataModel;

public class DeepLearnerGui
extends GuiContainer {
    public static final int WIDTH = 338;
    public static final int HEIGHT = 235;
    private FontRenderer renderer;
    protected ItemStack deepLearner;
    private MobMetaData meta;
    private World world;
    private NonNullList<ItemStack> validDataModels;
    private int currentItem = 0;
    private static final ResourceLocation base = new ResourceLocation("deepmoblearning", "textures/gui/deeplearner_base.png");
    private static final ResourceLocation extras = new ResourceLocation("deepmoblearning", "textures/gui/deeplearner_extras.png");
    private static final ResourceLocation defaultGui = new ResourceLocation("deepmoblearning", "textures/gui/default_gui.png");

    public DeepLearnerGui(InventoryPlayer inventory, World world, EntityEquipmentSlot slot, ItemStack heldItem) {
        super((Container)new ContainerDeepLearner(inventory, world, slot, heldItem));
        this.world = world;
        this.renderer = Minecraft.func_71410_x().field_71466_p;
        this.deepLearner = heldItem;
        this.field_146999_f = 338;
        this.field_147000_g = 235;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(base);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(left + 41, top, 0, 0, 256, 140);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(defaultGui);
        this.func_73729_b(left + 81, top + 145, 0, 0, 176, 90);
        NonNullList<ItemStack> list = ItemDeepLearner.getContainedItems(this.deepLearner);
        this.validDataModels = DataModel.getValidFromList(list);
        if (this.validDataModels.size() > 1) {
            this.renderCycleButtons(left, top, mouseX, mouseY);
        }
        if (this.currentItem >= this.validDataModels.size()) {
            this.currentItem = this.previousItemIndex();
        }
        if (this.validDataModels.size() >= 1 && this.currentItem < this.validDataModels.size()) {
            this.meta = DataModel.getMobMetaData((ItemStack)this.validDataModels.get(this.currentItem));
            this.renderMetaDataText(this.meta, left, top, (ItemStack)this.validDataModels.get(this.currentItem));
            this.renderMobDisplayBox(left, top);
            this.renderEntity(this.meta.getEntity(this.world), this.meta.getInterfaceScale(), left + this.meta.getInterfaceOffsetX(), top + 80 + this.meta.getInterfaceOffsetY(), partialTicks);
            if (this.meta instanceof ZombieMeta || this.meta instanceof SpiderMeta) {
                this.renderEntity(this.meta.getExtraEntity(this.world), this.meta.getInterfaceScale(), left + this.meta.getExtraInterfaceOffsetX(), top + 80 + this.meta.getExtraInterfaceOffsetY(), partialTicks);
            }
        } else {
            this.renderDefaultScreen(left, top);
        }
    }

    private int nextItemIndex() {
        int result = this.currentItem == this.validDataModels.size() - 1 ? 0 : this.currentItem + 1;
        return result;
    }

    private int previousItemIndex() {
        int result = this.currentItem == 0 ? (this.validDataModels.size() > 1 ? this.validDataModels.size() - 1 : 0) : this.currentItem - 1;
        return result;
    }

    private void renderCycleButtons(int left, int top, int mouseX, int mouseY) {
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(extras);
        this.func_73729_b(left - 27, top + 105, 75, 0, 24, 24);
        this.func_73729_b(left - 1, top + 105, 99, 0, 24, 24);
        if (x >= -27 && x < -3 && 105 <= y && y < 129) {
            this.func_73729_b(left - 27, top + 105, 75, 24, 24, 24);
        } else if (x >= -2 && x < 23 && 105 <= y && y < 129) {
            this.func_73729_b(left - 1, top + 105, 99, 24, 24, 24);
        }
    }

    protected void func_73864_a(int mX, int mY, int mouseButton) throws IOException {
        int x = mX - this.field_147003_i;
        int y = mY - this.field_147009_r;
        if (this.validDataModels.size() > 1 && x >= -27 && x < 23 && 105 <= y && y < 129) {
            if (-27 <= x && x < -3) {
                this.currentItem = this.previousItemIndex();
            } else if (-2 <= x && x < 23) {
                this.currentItem = this.nextItemIndex();
            }
        }
        super.func_73864_a(mX, mY, mouseButton);
    }

    private void renderDefaultScreen(int left, int top) {
        int leftStart = left + 49;
        int spacing = 12;
        this.func_73731_b(this.renderer, "No Data Model Found", leftStart, top + spacing, 6478079);
        this.func_73731_b(this.renderer, "Please insert a Data Model!", leftStart, top + spacing * 2, 0xFFFFFF);
        this.func_73731_b(this.renderer, "Your data models will collect data", leftStart, top + spacing * 3, 0xFFFFFF);
        this.func_73731_b(this.renderer, "when they are placed in the deep learner.", leftStart, top + spacing * 4, 0xFFFFFF);
        this.func_73731_b(this.renderer, "In order to collect data, you must", leftStart, top + spacing * 6, 0xFFFFFF);
        this.func_73731_b(this.renderer, "deliver the killing blow.", leftStart, top + spacing * 7, 0xFFFFFF);
    }

    private void renderMetaDataText(MobMetaData meta, int left, int top, ItemStack stack) {
        DecimalFormat f = new DecimalFormat("0.#");
        int leftStart = left + 49;
        int topStart = top - 4;
        int spacing = 12;
        this.func_73731_b(this.renderer, "Name", leftStart, topStart + spacing, 6478079);
        this.func_73731_b(this.renderer, "The " + meta.getName(), leftStart, topStart + spacing * 2, 0xFFFFFF);
        this.func_73731_b(this.renderer, "Information", leftStart, topStart + spacing * 3, 6478079);
        String[] mobTrivia = meta.getMobTrivia();
        for (int i = 0; i < mobTrivia.length; ++i) {
            this.func_73731_b(this.renderer, mobTrivia[i], leftStart, topStart + spacing * 3 + (i + 1) * 12, 0xFFFFFF);
        }
        String dataModelTier = DataModel.getTierName(stack, false);
        String nextTier = DataModel.getTierName(stack, true);
        String pluralMobName = DataModel.getMobMetaData(stack).getPluralName();
        int totalKills = DataModel.getTotalKillCount(stack);
        double killsToNextTier = DataModel.getKillsToNextTier(stack);
        this.func_73731_b(this.renderer, "Model Tier: " + dataModelTier, leftStart, topStart + spacing * 8, 0xFFFFFF);
        this.func_73731_b(this.renderer, pluralMobName + " defeated: " + totalKills, leftStart, topStart + spacing * 9, 0xFFFFFF);
        if (DataModel.getTier(stack) != 4) {
            this.func_73731_b(this.renderer, "Defeat " + f.format(killsToNextTier) + " more to reach " + nextTier, leftStart, topStart + spacing * 10, 0xFFFFFF);
        } else {
            this.func_73731_b(this.renderer, "Maximum tier achieved", leftStart, topStart + spacing * 10, 0xFFFFFF);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(base);
        this.func_73729_b(left + 235, topStart + spacing * 2 - 2, 0, 140, 9, 9);
        this.func_73731_b(this.renderer, "Life points", left + 235, topStart + spacing, 6478079);
        int numOfHearts = meta.getNumberOfHearts();
        if (numOfHearts == 0) {
            this.func_73731_b(this.renderer, "\u00a7k10\u00a7r", left + 246, topStart + spacing * 2 - 1, 0xFFFFFF);
        } else {
            this.func_73731_b(this.renderer, "" + meta.getNumberOfHearts(), left + 246, topStart + spacing * 2 - 1, 0xFFFFFF);
        }
    }

    private void renderMobDisplayBox(int left, int top) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(extras);
        this.func_73729_b(left - 41, top, 0, 0, 75, 101);
    }

    private void renderEntity(Entity entity, float scale, float x, float y, float partialTicks) {
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double heightOffset = Math.sin((double)((float)this.world.func_82737_E() + partialTicks) / 16.0) / 8.0;
        GlStateManager.func_179137_b((double)0.2f, (double)(0.0 + heightOffset), (double)15.0);
        GlStateManager.func_179114_b((float)(((float)this.world.func_82737_E() + partialTicks) * 3.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 1.0f, 0.0f, true);
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }
}

