/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.plugins.jei;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import xt9.deepmoblearning.common.Registry;

public class ExtractionChamberRecipeCategory
implements IRecipeCategory {
    private ItemStack catalyst;
    private IDrawable background;
    private IDrawableAnimated progress;

    public ExtractionChamberRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation base = new ResourceLocation("deepmoblearning", "textures/gui/jei/extraction_chamber.png");
        this.catalyst = new ItemStack(Registry.extractionChamberItem);
        this.background = guiHelper.createDrawable(base, 0, 0, 103, 30, 0, 0, 0, 0);
        IDrawableStatic progress = guiHelper.createDrawable(base, 0, 30, 35, 6);
        this.progress = guiHelper.createAnimatedDrawable(progress, 120, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 8, 6);
        guiItemStacks.init(1, false, 76, 6);
        guiItemStacks.set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        guiItemStacks.set(1, (List)ingredients.getOutputs(ItemStack.class).get(0));
    }

    public void addCatalysts(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)this.catalyst, new String[]{this.getUid()});
    }

    public String getUid() {
        return "deepmoblearning.extraction_chamber";
    }

    public String getTitle() {
        return this.catalyst.func_82833_r();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.progress.draw(minecraft, 34, 12);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    public String getModName() {
        return "deepmoblearning";
    }
}

