/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.lumberjack.util;

import java.util.List;

public class Constants {
    public static final String MODID = "lumberjack";
    public static final String MOD_NAME = "LumberJack";
    public static final String VERSION = "1.4.1";

    public static String makeTable(TableData ... datas) {
        int size = 0;
        for (TableData data : datas) {
            size += data.width * data.strings.size();
        }
        StringBuilder stringBuilder = new StringBuilder(size);
        for (TableData data : datas) {
            stringBuilder.append('|').append(' ').append(data.header).append(new String(new char[data.width - data.header.length() + 1]).replace('\u0000', ' '));
        }
        stringBuilder.append('|').append('\n');
        for (TableData data : datas) {
            stringBuilder.append('+').append(new String(new char[data.width + 2]).replace('\u0000', '-'));
        }
        stringBuilder.append('+').append('\n');
        for (int i = 0; i < datas[0].strings.size(); ++i) {
            for (TableData data : datas) {
                stringBuilder.append('|').append(' ').append(data.strings.get(i)).append(new String(new char[data.width - data.strings.get(i).length() + 1]).replace('\u0000', ' '));
            }
            stringBuilder.append('|').append('\n');
        }
        return stringBuilder.toString();
    }

    public static final class TableData {
        public String header;
        public List<String> strings;
        private int width;

        public TableData(String header, List<String> data) {
            this.header = header;
            this.strings = data;
            this.width = header.length();
            this.updateWidth();
        }

        private void updateWidth() {
            for (String string : this.strings) {
                if (this.width >= string.length()) continue;
                this.width = string.length();
            }
        }
    }
}

