/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.lumberjack.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.UUID;
import net.doubledoordev.lumberjack.Lumberjack;
import net.doubledoordev.lumberjack.items.ItemLumberAxe;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    public static final EventHandler I = new EventHandler();
    private HashMultimap<UUID, BlockPos> pointMap = HashMultimap.create();
    private HashMultimap<UUID, BlockPos> nextMap = HashMultimap.create();

    private EventHandler() {
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!event.side.isServer()) {
            return;
        }
        UUID uuid = event.player.func_110124_au();
        if (!this.nextMap.containsKey((Object)uuid) || this.nextMap.get((Object)uuid).isEmpty()) {
            return;
        }
        int i = 0;
        for (BlockPos point : ImmutableSet.copyOf((Collection)this.nextMap.get((Object)uuid))) {
            ((EntityPlayerMP)event.player).field_71134_c.func_180237_b(point);
            this.nextMap.remove((Object)uuid, (Object)point);
            if (i++ <= Lumberjack.getTickLimit()) continue;
            break;
        }
        if (this.pointMap.get((Object)uuid).size() > Lumberjack.getTotalLimit()) {
            this.nextMap.removeAll((Object)uuid);
        }
        if (!this.nextMap.containsKey((Object)uuid) || !this.nextMap.get((Object)uuid).isEmpty()) {
            this.pointMap.removeAll((Object)uuid);
        }
    }

    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        UUID uuid = player.func_110124_au();
        IBlockState state = event.getState();
        if (!(state.func_185904_a() == Material.field_151575_d || Lumberjack.getLeaves() && state.func_185904_a() == Material.field_151584_j)) {
            return;
        }
        ItemStack itemStack = player.func_184614_ca();
        if (itemStack == ItemStack.field_190927_a || !(itemStack.func_77973_b() instanceof ItemLumberAxe)) {
            return;
        }
        this.pointMap.put((Object)uuid, (Object)event.getPos());
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    boolean isLeaves;
                    BlockPos newPoint = event.getPos().func_177982_a(offsetX, offsetY, offsetZ);
                    if (this.nextMap.containsEntry((Object)uuid, (Object)newPoint) || this.pointMap.containsEntry((Object)uuid, (Object)newPoint)) continue;
                    IBlockState newBlockState = event.getWorld().func_180495_p(newPoint);
                    boolean bl = isLeaves = Lumberjack.getLeaves() && newBlockState.func_185904_a() == Material.field_151584_j;
                    if ((Lumberjack.getMode() != 0 || !isLeaves && newBlockState.func_177230_c() != state.func_177230_c()) && (Lumberjack.getMode() != 1 || !isLeaves && newBlockState.func_185904_a() != Material.field_151575_d)) continue;
                    this.nextMap.put((Object)uuid, (Object)newPoint);
                }
            }
        }
    }
}

