/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.tileentity.TileBookshelf;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.PropertyUnlistedInteger;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.BlockInventory;
import slimeknights.mantle.property.PropertyString;

public class BlockBookshelf
extends BlockInventory
implements ITileEntityProvider {
    public static final PropertyEnum<BookshelfType> TYPE = PropertyEnum.func_177709_a((String)"type", BookshelfType.class);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyString TEXTURE = TextureBlockUtil.TEXTURE_PROP;
    public static final IUnlistedProperty<Integer> BOOKS = new PropertyUnlistedInteger("books");
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> BOUNDS;
    private static final ImmutableMap<EnumFacing, AxisAlignedBB[]> TRACE_BOUNDS;

    public BlockBookshelf() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    protected ExtendedBlockState createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TYPE, FACING}, new IUnlistedProperty[]{TEXTURE, BOOKS});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)BookshelfType.fromMeta(meta & 3))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta >> 2)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2 | ((BookshelfType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    @Deprecated
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TextureBlockUtil.placeTextureBlock(world, pos, stack);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileBookshelf();
    }

    protected boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        player.openGui((Object)Inspirations.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float clickX, float clickY, float clickZ) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing != side) {
            return false;
        }
        if (player.func_70093_af()) {
            return world.field_72995_K || this.openGui(player, world, pos);
        }
        int book = BlockBookshelf.bookClicked(facing, clickX, clickY, clickZ);
        if (book == -1) {
            return world.field_72995_K || this.openGui(player, world, pos);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileBookshelf) {
            if (((TileBookshelf)te).interact(player, hand, book)) {
                return true;
            }
            if (InspirationsRegistry.isBook(player.func_184592_cb())) {
                return false;
            }
        }
        return true;
    }

    private static int bookClicked(EnumFacing facing, float clickX, float clickY, float clickZ) {
        double z2;
        if ((double)clickY < 0.0625 || (double)clickY > 0.9375) {
            return -1;
        }
        int shelf = 0;
        if ((double)clickY <= 0.4375) {
            shelf = 7;
        } else if ((double)clickY < 0.5625) {
            return -1;
        }
        int offX = facing.func_82601_c();
        int offZ = facing.func_82599_e();
        double x1 = offX == -1 ? 0.625 : 0.0625;
        double z1 = offZ == -1 ? 0.625 : 0.0625;
        double x2 = offX == 1 ? 0.375 : 0.9375;
        double d = z2 = offZ == 1 ? 0.375 : 0.9375;
        if ((double)clickX < x1 || (double)clickX > x2 || (double)clickZ < z1 || (double)clickZ > z2) {
            return -1;
        }
        EnumFacing dir = facing.func_176735_f();
        double clicked = (double)((float)dir.func_82601_c() * clickX + (float)dir.func_82599_e() * clickZ) - 0.0625;
        if (clicked < 0.0) {
            clicked = 1.0 + clicked;
        }
        return shelf + Math.min((int)(clicked * 8.0), 7);
    }

    @Deprecated
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (AxisAlignedBB)BOUNDS.get((Object)state.func_177229_b((IProperty)FACING));
    }

    @Deprecated
    public RayTraceResult func_180636_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        ArrayList<RayTraceResult> list = new ArrayList<RayTraceResult>(6);
        for (AxisAlignedBB bound : (AxisAlignedBB[])TRACE_BOUNDS.get((Object)state.func_177229_b((IProperty)FACING))) {
            list.add(this.func_185503_a(pos, start, end, bound));
        }
        return Util.closestResult(list, end);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (this.getPower(state, (IBlockAccess)world, pos) > 0) {
            world.func_175685_c(pos, (Block)this, false);
            world.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()), (Block)this, false);
        }
        super.func_180663_b(world, pos, state);
    }

    @Deprecated
    public int func_180656_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getPower(state, blockAccess, pos);
    }

    @Deprecated
    public int func_176211_b(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (state.func_177229_b((IProperty)FACING) != side) {
            return 0;
        }
        return this.getPower(state, blockAccess, pos);
    }

    private int getPower(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        if (InspirationsBuilding.redstoneBook == null) {
            return 0;
        }
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te instanceof TileBookshelf) {
            return ((TileBookshelf)te).getPower();
        }
        return 0;
    }

    @Deprecated
    public boolean func_149744_f(IBlockState state) {
        return InspirationsBuilding.redstoneBook != null;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileBookshelf) {
            return ((TileBookshelf)te).writeExtendedBlockState(extendedState);
        }
        return super.getExtendedState(state, world, pos);
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side == ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BookshelfType type : BookshelfType.values()) {
            TextureBlockUtil.addBlocksFromOredict("slabWood", (Block)this, type.getMeta(), list);
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((BookshelfType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return TextureBlockUtil.getBlockItemStack((IBlockAccess)world, pos, state);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        world.func_175698_g(pos);
        return false;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)TextureBlockUtil.getBlockItemStack(world, pos, state));
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        if (!Config.bookshelvesBoostEnchanting) {
            return 0.0f;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileBookshelf) {
            return ((TileBookshelf)te).getEnchantPower();
        }
        return 0.0f;
    }

    static {
        ImmutableMap.Builder bounds = ImmutableMap.builder();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumFacing side : EnumFacing.field_176754_o) {
            int offX = side.func_82601_c();
            int offZ = side.func_82599_e();
            double x1 = offX == -1 ? 0.5 : 0.0;
            double z1 = offZ == -1 ? 0.5 : 0.0;
            double x2 = offX == 1 ? 0.5 : 1.0;
            double z2 = offZ == 1 ? 0.5 : 1.0;
            bounds.put((Object)side, (Object)new AxisAlignedBB(x1, 0.0, z1, x2, 1.0, z2));
            builder.put((Object)side, (Object)new AxisAlignedBB[]{new AxisAlignedBB(x1, 0.0, z1, x2, 0.0625, z2), new AxisAlignedBB(x1, 0.4375, z1, x2, 0.5625, z2), new AxisAlignedBB(x1, 0.9375, z1, x2, 1.0, z2), new AxisAlignedBB(offX == -1 ? 0.625 : 0.0, 0.0, offZ == -1 ? 0.625 : 0.0, offX == 1 ? 0.375 : 1.0, 1.0, offZ == 1 ? 0.375 : 1.0), new AxisAlignedBB(x1, 0.0, z1, offX == 0 ? 0.0625 : x2, 1.0, offZ == 0 ? 0.0625 : z2), new AxisAlignedBB(offX == 0 ? 0.9375 : x1, 0.0, offZ == 0 ? 0.9375 : z1, x2, 1.0, z2)});
        }
        BOUNDS = bounds.build();
        TRACE_BOUNDS = builder.build();
    }

    public static enum BookshelfType implements IStringSerializable
    {
        NORMAL,
        RAINBOW,
        TOMES,
        ANCIENT;

        private int meta = this.ordinal();

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }

        public static BookshelfType fromMeta(int meta) {
            if (meta < 0 || meta >= BookshelfType.values().length) {
                meta = 0;
            }
            return BookshelfType.values()[meta];
        }
    }
}

