/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe;

import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.SoundEvent;

public class FillCauldronFromPotion
implements ICauldronRecipe {
    private ItemStack bottle;
    private Item potion;

    public FillCauldronFromPotion(Item potion, ItemStack bottle) {
        this.bottle = bottle;
        this.potion = potion;
    }

    @Override
    public boolean matches(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return level < InspirationsRegistry.getCauldronMax() && (level == 0 || state.getPotion() != null) && stack.func_77973_b() == this.potion;
    }

    @Override
    public ItemStack getResult(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return this.bottle.func_77946_l();
    }

    @Override
    public int getLevel(int level) {
        return level + 1;
    }

    @Override
    public ICauldronRecipe.CauldronState getState(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        PotionType inputType = PotionUtils.func_185191_c((ItemStack)stack);
        if (level == 0) {
            return ICauldronRecipe.CauldronState.potion(inputType);
        }
        if (state.getPotion() != inputType) {
            return ICauldronRecipe.CauldronState.potion(PotionTypes.field_185232_d);
        }
        return state;
    }

    @Override
    public SoundEvent getSound(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        if (level > 0 && PotionUtils.func_185191_c((ItemStack)stack) != state.getPotion()) {
            return SoundEvents.field_187646_bt;
        }
        return SoundEvents.field_191241_J;
    }

    @Override
    public ItemStack getContainer(ItemStack stack) {
        return ItemStack.field_190927_a;
    }
}

