/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.entities.entityarrow.EntityCoalArrow;
import com.sofodev.armorplus.common.registry.entities.entityarrow.EntityEnderDragonArrow;
import com.sofodev.armorplus.common.registry.entities.entityarrow.EntityLapisArrow;
import com.sofodev.armorplus.common.registry.entities.entityarrow.EntityLavaArrow;
import com.sofodev.armorplus.common.registry.entities.entityarrow.EntityRedstoneArrow;
import com.sofodev.armorplus.common.registry.entities.mobs.EntityEnderDragonZombie;
import com.sofodev.armorplus.common.registry.entities.mobs.EntityIceGolem;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.demonicdragon.EntityDemonicDragon;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.guardianoverlord.EntityGuardianOverlord;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.guardianoverlord.projectile.EntityFreezeBomb;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.EntitySkeletalKing;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.projectile.EntityWitherMinion;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.projectile.EntityWitherling;
import com.sofodev.armorplus.common.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod.EventBusSubscriber(modid="armorplus")
public class ModEntities {
    public static void registerEntitySettings() {
        ModEntities.registerSpawns();
        ModEntities.registerLootTables();
    }

    private static void registerSpawns() {
        if (ModConfig.EntitiesConfig.ender_dragon_zombie.enableSpawnEnd) {
            EntityRegistry.addSpawn(EntityEnderDragonZombie.class, (int)1, (int)0, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76779_k});
        }
    }

    private static void registerLootTables() {
        LootTableList.func_186375_a((ResourceLocation)EntityEnderDragonZombie.LOOT);
    }

    private static void registerTracking() {
        EntityRegistry.instance().lookupModSpawn(EntitySkeletalKing.class, true);
    }

    private static void registerEntities(Class<? extends Entity> entityClass, String registryName, int id, boolean hasEgg, int primaryColor, int secondaryColor) {
        ResourceLocation resourceLocation = Utils.setRL(registryName);
        if (hasEgg) {
            EntityRegistry.registerModEntity((ResourceLocation)resourceLocation, entityClass, (String)registryName, (int)id, (Object)ArmorPlus.instance, (int)64, (int)1, (boolean)true, (int)primaryColor, (int)secondaryColor);
        } else {
            EntityRegistry.registerModEntity((ResourceLocation)resourceLocation, entityClass, (String)registryName, (int)id, (Object)ArmorPlus.instance, (int)64, (int)1, (boolean)true);
        }
    }

    private static void registerEntities(Class<? extends Entity> entityClass, String registryName, int id, int primaryColor, int secondaryColor) {
        ModEntities.registerEntities(entityClass, registryName, id, true, primaryColor, secondaryColor);
    }

    private static void registerEntities(Class<? extends Entity> entityClass, String registryName, int id) {
        ModEntities.registerEntities(entityClass, registryName, id, false, 0, 0);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        int id = 0;
        ModEntities.registerEntities(EntityCoalArrow.class, "coal_arrow", ++id);
        ModEntities.registerEntities(EntityLapisArrow.class, "lapis_arrow", ++id);
        ModEntities.registerEntities(EntityRedstoneArrow.class, "redstone_arrow", ++id);
        ModEntities.registerEntities(EntityLavaArrow.class, "lava_arrow", ++id);
        ModEntities.registerEntities(EntityEnderDragonArrow.class, "ender_dragon_arrow", ++id);
        ModEntities.registerEntities(EntityFreezeBomb.class, "freeze_bomb", ++id);
        ModEntities.registerEntities(EntityWitherMinion.class, "wither_minion", ++id);
        ModEntities.registerEntities(EntityEnderDragonZombie.class, "ender_dragon_zombie", ++id, 7475556, 65280);
        ModEntities.registerEntities(EntityIceGolem.class, "ice_golem", ++id, 0xFFFFFF, 65280);
        ModEntities.registerEntities(EntityGuardianOverlord.class, "overlord_of_the_guardians", ++id, 8054015, 7972607);
        ModEntities.registerEntities(EntitySkeletalKing.class, "skeletal_king", ++id, 6708050, 6708050);
        ModEntities.registerEntities(EntityWitherling.class, "witherling", ++id, 0x141414, 6642514);
        ModEntities.registerEntities(EntityDemonicDragon.class, "demonic_dragon", ++id, 7972607, 6642514);
    }
}

