/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.tileentity;

import com.sofodev.armorplus.api.lavainfuser.LavaInfuserManager;
import com.sofodev.armorplus.api.lavainfuser.SlotLavaInfuserFuel;
import com.sofodev.armorplus.common.container.ContainerLavaInfuser;
import com.sofodev.armorplus.common.registry.ModItems;
import com.sofodev.armorplus.common.registry.blocks.lava.BlockLavaInfuser;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public class TileLavaInfuser
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 1};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private NonNullList<ItemStack> infuserItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int infuserInfusingTime;
    private int currentItemInfusingTime;
    private int infusingTime;
    private int totalInfusingTime;
    private String infuserCustomName;
    private IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public static void registerFixesLavaInfuser(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileLavaInfuser.class, new String[]{"Items"}));
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isInfusing(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public static int getItemChargeTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        return item == Items.field_151129_at || item == ModItems.itemLavaCrystal ? 500 : ForgeEventFactory.getItemBurnTime((ItemStack)stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileLavaInfuser.isItemValid(stack) && TileLavaInfuser.getItemChargeTime(stack) > 0;
    }

    public static boolean isItemValid(ItemStack stack) {
        return stack == ItemStackUtils.getItemStack((Object)Items.field_151129_at) || stack == ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal);
    }

    public int func_70302_i_() {
        return this.infuserItemStacks.size();
    }

    public boolean func_191420_l() {
        return this.infuserItemStacks.stream().allMatch(ItemStack::func_190926_b);
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.infuserItemStacks.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.infuserItemStacks, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.infuserItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.infuserItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.infuserItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalInfusingTime = this.getInfusionTime(stack);
            this.infusingTime = 0;
            this.func_70296_d();
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.infuserCustomName : "container.armorplus.lava_infuser";
    }

    public boolean func_145818_k_() {
        return this.infuserCustomName != null && !this.infuserCustomName.isEmpty();
    }

    public void setCustomInventoryName(String invName) {
        this.infuserCustomName = invName;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.infuserItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.infuserItemStacks);
        this.infuserInfusingTime = compound.func_74762_e("BurnTime");
        this.infusingTime = compound.func_74762_e("InfusingTime");
        this.totalInfusingTime = compound.func_74762_e("InfusingTimeTotal");
        this.currentItemInfusingTime = TileLavaInfuser.getItemChargeTime((ItemStack)this.infuserItemStacks.get(1));
        if (compound.func_150297_b("CustomName", 8)) {
            this.infuserCustomName = compound.func_74779_i("CustomName");
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.infuserInfusingTime));
        compound.func_74768_a("InfusingTime", (int)((short)this.infusingTime));
        compound.func_74768_a("InfusingTimeTotal", (int)((short)this.totalInfusingTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.infuserItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.infuserCustomName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isInfusing() {
        return this.infuserInfusingTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isInfusing();
        boolean flag1 = false;
        if (this.isInfusing()) {
            --this.infuserInfusingTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.infuserItemStacks.get(1);
            if (this.isInfusing() || !itemstack.func_190926_b() && !((ItemStack)this.infuserItemStacks.get(0)).func_190926_b()) {
                if (!this.isInfusing() && this.canCharge()) {
                    this.currentItemInfusingTime = this.infuserInfusingTime = TileLavaInfuser.getItemChargeTime(itemstack);
                    if (this.isInfusing()) {
                        flag1 = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.infuserItemStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isInfusing() && this.canCharge()) {
                    ++this.infusingTime;
                    if (this.infusingTime == this.totalInfusingTime) {
                        this.infusingTime = 0;
                        this.totalInfusingTime = this.getInfusionTime((ItemStack)this.infuserItemStacks.get(0));
                        this.chargeItem();
                        flag1 = true;
                    }
                } else {
                    this.infusingTime = 0;
                }
            } else if (!this.isInfusing() && this.infusingTime > 0) {
                this.infusingTime = MathHelper.func_76125_a((int)(this.infusingTime - 2), (int)0, (int)this.totalInfusingTime);
            }
            if (flag != this.isInfusing()) {
                flag1 = true;
                BlockLavaInfuser.setState(this.isInfusing(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getInfusionTime(ItemStack stack) {
        return 50;
    }

    private boolean canCharge() {
        if (((ItemStack)this.infuserItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = LavaInfuserManager.getInstance().getInfusingResult((ItemStack)this.infuserItemStacks.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.infuserItemStacks.get(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        int result = itemstack1.func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= itemstack1.func_77976_d();
    }

    public void chargeItem() {
        if (this.canCharge()) {
            ItemStack itemstack = (ItemStack)this.infuserItemStacks.get(0);
            ItemStack itemstack1 = LavaInfuserManager.getInstance().getInfusingResult(itemstack);
            ItemStack itemstack2 = (ItemStack)this.infuserItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.infuserItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            itemstack.func_190918_g(1);
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.infuserItemStacks.get(1);
        return TileLavaInfuser.isItemFuel(stack) || SlotLavaInfuserFuel.isAllowed(stack) && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    @Nonnull
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_BOTTOM;
        }
        return side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && index == 1) {
            Item item = stack.func_77973_b();
            return item == Items.field_151131_as || item == Items.field_151133_ar;
        }
        return true;
    }

    @Nonnull
    public String func_174875_k() {
        return "armorplus:lava_infuser";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerLavaInfuser(playerInventory, this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.infuserInfusingTime;
            }
            case 1: {
                return this.currentItemInfusingTime;
            }
            case 2: {
                return this.infusingTime;
            }
            case 3: {
                return this.totalInfusingTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.infuserInfusingTime = value;
                break;
            }
            case 1: {
                this.currentItemInfusingTime = value;
                break;
            }
            case 2: {
                this.infusingTime = value;
                break;
            }
            case 3: {
                this.totalInfusingTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.infuserItemStacks.clear();
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case DOWN: {
                    return (T)this.handlerBottom;
                }
                case UP: {
                    return (T)this.handlerTop;
                }
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }
}

