/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import codechicken.lib.reflect.ObfMapping;
import codechicken.lib.reflect.ReflectionManager;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.brandon3055.draconicevolution.lib.ManualImageLocation;
import com.google.common.io.ByteStreams;
import com.google.gson.stream.JsonWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.io.FilenameUtils;

@Deprecated
public class DEImageHandler {
    public static DEImageHandler instance = new DEImageHandler();
    public static Map<String, ManualImageLocation> downloadedImages = new HashMap<String, ManualImageLocation>();
    public static ObfMapping defaultResourcePacksMapping = new ObfMapping("net/minecraft/client/Minecraft", "field_110449_ao");
    private static String savePath;
    private static File saveFolder;
    private static File imagesFolder;
    private static DownloadThread downloadThread;
    public static int downloadStatus;

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (downloadThread != null && downloadThread.isFinished) {
            if (downloadThread.isReloadRequired()) {
                LogHelperBC.info((Object)"Image Download Finished");
            }
            downloadStatus = downloadThread.wasSuccessful ? 1 : 2;
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            DEImageHandler.addRSPack(event != null);
            downloadThread = null;
        }
    }

    public static void init(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        if (event != null) {
            savePath = event.getModConfigurationDirectory().getParentFile().getAbsolutePath() + "/config/draconicevolution";
        }
    }

    private static void addRSPack(boolean refreash) {
        File rspack = new File(DEImageHandler.getConfigFolder(), "/resources");
        if (!rspack.exists()) {
            return;
        }
        if (!Arrays.asList(rspack.list()).contains("pack.mcmeta")) {
            try {
                JsonWriter writer = new JsonWriter((Writer)new FileWriter(new File(rspack, "pack.mcmeta")));
                writer.beginObject();
                writer.name("pack");
                writer.beginObject();
                writer.name("pack_format").value(1L);
                writer.name("description").value("Draconic Evolution GUI Images");
                writer.endObject();
                writer.endObject();
                writer.close();
            }
            catch (IOException e) {
                LogHelperBC.error((Object)"Error creating pack.mcmeta");
                e.printStackTrace();
            }
        }
        try {
            List defaultResourcePacks = (List)ReflectionManager.getField((ObfMapping)defaultResourcePacksMapping, (Object)Minecraft.func_71410_x(), List.class);
            defaultResourcePacks.add(new FolderResourcePack(rspack));
            LogHelperBC.info((Object)"RS Added");
            if (refreash) {
                Minecraft.func_71410_x().func_110436_a();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static File getConfigFolder() {
        if (saveFolder == null) {
            saveFolder = new File(savePath);
        }
        if (!saveFolder.exists()) {
            saveFolder.mkdir();
        }
        return saveFolder;
    }

    public static File getImagesFolder() {
        if (imagesFolder == null) {
            imagesFolder = new File(DEImageHandler.getConfigFolder(), "/resources/assets/draconicevolution/textures/gui/manualimages");
        }
        if (!imagesFolder.exists()) {
            imagesFolder.mkdirs();
        }
        return imagesFolder;
    }

    static {
        downloadStatus = 0;
    }

    public static class DownloadThread
    extends Thread {
        private List<String> imageURLs;
        private boolean isFinished = false;
        private boolean wasSuccessful = true;
        private boolean reloadRequired = false;

        public DownloadThread(List<String> imageURLs) {
            this.imageURLs = new ArrayList<String>(imageURLs);
        }

        @Override
        public void run() {
            for (String s : this.imageURLs) {
                if (!DownloadThread.checkExistence(s) && DownloadThread.downloadImage(s)) {
                    this.reloadRequired = true;
                }
                if (!DownloadThread.checkExistence(s)) continue;
                try {
                    URL url = new URL(s);
                    String fileName = url.getFile();
                    BufferedImage bi = ImageIO.read(new File(DEImageHandler.getImagesFolder(), FilenameUtils.getName((String)fileName)));
                    downloadedImages.put(FilenameUtils.getName((String)fileName), new ManualImageLocation(FilenameUtils.getName((String)fileName), bi.getWidth(), bi.getHeight()));
                }
                catch (MalformedURLException e) {
                    LogHelperBC.error((Object)"Image Read Failed");
                    e.printStackTrace();
                }
                catch (IOException e) {
                    LogHelperBC.error((Object)"Image Read Failed");
                    e.printStackTrace();
                }
            }
            this.isFinished = true;
        }

        private static boolean downloadImage(String urlString) {
            try {
                URL url = new URL(urlString);
                String fileName = url.getFile();
                LogHelperBC.info((Object)("Downloading Image " + FilenameUtils.getName((String)fileName)));
                File dll = new File(DEImageHandler.getImagesFolder(), FilenameUtils.getName((String)fileName));
                InputStream is = url.openStream();
                FileOutputStream os = new FileOutputStream(dll);
                ByteStreams.copy((InputStream)is, (OutputStream)os);
                is.close();
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                LogHelperBC.error((Object)"Download Failed");
                e.printStackTrace();
                return false;
            }
            return true;
        }

        private static boolean checkExistence(String urlS) {
            try {
                URL url = new URL(urlS);
                String fileName = url.getFile();
                return Arrays.asList(DEImageHandler.getImagesFolder().list()).contains(FilenameUtils.getName((String)fileName));
            }
            catch (MalformedURLException e) {
                LogHelperBC.error((Object)("Unable to check files existence. Invalid URL: " + urlS));
                e.printStackTrace();
                return false;
            }
        }

        public boolean isFinished() {
            return this.isFinished;
        }

        public boolean wasSuccessful() {
            return this.wasSuccessful;
        }

        public boolean isReloadRequired() {
            return this.reloadRequired;
        }
    }
}

