/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;
import modulardiversity.util.ICraftingResourceHolder;
import modulardiversity.util.IResourceToken;

public abstract class RequirementConsumePerTick<T, V extends IResourceToken>
extends ComponentRequirement.PerTick<T> {
    V checkToken;
    V perTickToken;

    public RequirementConsumePerTick(ComponentType componentType, MachineComponent.IOType actionType) {
        super(componentType, actionType);
    }

    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance resultChance) {
        return true;
    }

    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance resultChance) {
        return true;
    }

    protected String getMissingInput() {
        return "craftcheck." + this.getRequiredComponentType().getRegistryName() + ".input";
    }

    protected String getMissingOutput() {
        return "craftcheck." + this.getRequiredComponentType().getRegistryName() + ".output";
    }

    protected String getMiscProblem() {
        return "craftcheck.failure.misc";
    }

    public CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List<ComponentOutputRestrictor> list) {
        if (!this.isCorrectHatch(component)) {
            return CraftCheck.skipComponent();
        }
        ICraftingResourceHolder handler = (ICraftingResourceHolder)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                boolean didConsume = handler.consume(this.checkToken, false);
                if (!didConsume) {
                    return CraftCheck.failure((String)handler.getInputProblem(this.checkToken));
                }
                if (this.checkToken.isEmpty()) {
                    return CraftCheck.success();
                }
                return CraftCheck.partialSuccess();
            }
            case OUTPUT: {
                boolean didGenerate = handler.generate(this.checkToken, false);
                if (!didGenerate) {
                    return CraftCheck.failure((String)handler.getOutputProblem(this.checkToken));
                }
                if (this.checkToken.isEmpty()) {
                    return CraftCheck.success();
                }
                return CraftCheck.partialSuccess();
            }
        }
        return CraftCheck.failure((String)this.getMiscProblem());
    }

    public void startRequirementCheck(ResultChance chance, RecipeCraftingContext context) {
        this.checkToken = this.emitConsumptionToken(context);
        this.checkToken.applyModifiers(context, this.getActionType(), 1.0f);
    }

    public void endRequirementCheck() {
        this.checkToken = this.emitConsumptionToken(null);
    }

    public CraftCheck resetIOTick(RecipeCraftingContext context) {
        boolean enough = this.perTickToken != null && this.perTickToken.isEmpty();
        this.perTickToken = this.emitConsumptionToken(context);
        if (enough) {
            return CraftCheck.success();
        }
        if (this.getActionType() == MachineComponent.IOType.INPUT) {
            return CraftCheck.failure((String)this.getMissingInput());
        }
        return CraftCheck.failure((String)this.getMissingOutput());
    }

    public void startIOTick(RecipeCraftingContext context, float durationMultiplier) {
        this.perTickToken.applyModifiers(context, this.getActionType(), durationMultiplier);
    }

    protected abstract V emitConsumptionToken(RecipeCraftingContext var1);

    protected abstract boolean isCorrectHatch(MachineComponent var1);

    @Nonnull
    public CraftCheck doIOTick(MachineComponent component, RecipeCraftingContext context) {
        if (!this.isCorrectHatch(component)) {
            return CraftCheck.skipComponent();
        }
        ICraftingResourceHolder handler = (ICraftingResourceHolder)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                boolean didConsume = handler.consume(this.perTickToken, true);
                if (!didConsume) {
                    return CraftCheck.failure((String)handler.getInputProblem(this.perTickToken));
                }
                if (this.perTickToken.isEmpty()) {
                    return CraftCheck.success();
                }
                return CraftCheck.partialSuccess();
            }
            case OUTPUT: {
                boolean didGenerate = handler.generate(this.perTickToken, true);
                if (!didGenerate) {
                    return CraftCheck.failure((String)handler.getOutputProblem(this.perTickToken));
                }
                if (this.perTickToken.isEmpty()) {
                    return CraftCheck.success();
                }
                return CraftCheck.partialSuccess();
            }
        }
        return CraftCheck.failure((String)this.getMiscProblem());
    }
}

