/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

public class JsonUtil {
    public static void onlyOne(JsonObject json, String ... names) {
        boolean hasNamePrev = false;
        for (String name : names) {
            boolean hasName = json.has(name);
            if (hasNamePrev && hasName) {
                throw new JsonParseException("Element cannot have ");
            }
            hasNamePrev = hasName;
        }
    }

    public static String get(JsonObject json, String name, String defaultValue) {
        if (json.has(name)) {
            return json.getAsJsonPrimitive(name).getAsString();
        }
        return defaultValue;
    }

    public static boolean get(JsonObject json, String name, boolean defaultValue) {
        if (json.has(name)) {
            return json.getAsJsonPrimitive(name).getAsBoolean();
        }
        return defaultValue;
    }

    public static int get(JsonObject json, String name, int defaultValue) {
        if (json.has(name)) {
            return json.getAsJsonPrimitive(name).getAsInt();
        }
        return defaultValue;
    }

    public static long get(JsonObject json, String name, long defaultValue) {
        if (json.has(name)) {
            return json.getAsJsonPrimitive(name).getAsLong();
        }
        return defaultValue;
    }

    public static float get(JsonObject json, String name, float defaultValue) {
        if (json.has(name)) {
            return json.getAsJsonPrimitive(name).getAsFloat();
        }
        return defaultValue;
    }

    public static double get(JsonObject json, String name, double defaultValue) {
        if (json.has(name)) {
            return json.getAsJsonPrimitive(name).getAsDouble();
        }
        return defaultValue;
    }

    public static boolean getPerTick(JsonObject json) {
        return JsonUtil.get(json, "perTick", false);
    }
}

