/*
 * Decompiled with CFR 0.152.
 */
package nc.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.block.property.BlockProperties;
import nc.capability.radiation.source.IRadiationSource;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface ITile {
    public World getTileWorld();

    public BlockPos getTilePos();

    public Block getTileBlockType();

    public int getTileBlockMeta();

    default public EnumFacing getFacingHorizontal() {
        return (EnumFacing)this.getTileBlockType().func_176203_a(this.getTileBlockMeta()).func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL);
    }

    default public IBlockState getBlockState(BlockPos pos) {
        return this.getTileWorld().func_180495_p(pos);
    }

    default public Block getBlock(BlockPos pos) {
        return this.getBlockState(pos).func_177230_c();
    }

    public IRadiationSource getRadiationSource();

    default public boolean shouldSaveRadiation() {
        return true;
    }

    public void setState(boolean var1, TileEntity var2);

    default public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
        this.refreshIsRedstonePowered(world, pos);
    }

    default public boolean checkIsRedstonePowered(World world, BlockPos pos) {
        return world.func_175640_z(pos);
    }

    default public void refreshIsRedstonePowered(World world, BlockPos pos) {
        this.setIsRedstonePowered(this.checkIsRedstonePowered(world, pos));
    }

    public boolean getIsRedstonePowered();

    public void setIsRedstonePowered(boolean var1);

    public boolean getAlternateComparator();

    public void setAlternateComparator(boolean var1);

    public boolean getRedstoneControl();

    public void setRedstoneControl(boolean var1);

    public void markTileDirty();

    public void markDirtyAndNotify();

    @Nonnull
    default public EnumFacing nonNullSide(@Nullable EnumFacing side) {
        return side == null ? EnumFacing.DOWN : side;
    }
}

