/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait.infinite;

import com.tictim.ceu.gui.InfiniteEnergyData;
import com.tictim.ceu.mte.MTEInfiniteEnergy;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteEnergy;
import com.tictim.ceu.util.Numbers;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import java.math.BigInteger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class TraitInfiniteGteuReceiver
extends TraitInfiniteEnergy
implements IEnergyContainer {
    public TraitInfiniteGteuReceiver(MTEInfiniteEnergy mte) {
        super(mte);
    }

    public String getName() {
        return "infinite_gteu_receiver";
    }

    public int getNetworkID() {
        return 1;
    }

    public <T> T getCapability(Capability<T> capability) {
        return (T)((Object)(capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER ? this : null));
    }

    @Override
    public ModularUI createUI(IUIHolder holder, EntityPlayer player) {
        return new InfiniteEnergyData(this).guiBuilder().energyInput("EU").buttonAcceptDecline().createUI(holder, player);
    }

    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        if (this.mte.isDisabled()) {
            return 0L;
        }
        this.add(BigInteger.valueOf(voltage * amperage));
        return amperage;
    }

    public boolean inputsEnergy(EnumFacing side) {
        return !this.mte.isDisabled();
    }

    public long changeEnergy(long differenceAmount) {
        this.add(BigInteger.valueOf(differenceAmount));
        return differenceAmount;
    }

    public long getInputAmperage() {
        return 64L;
    }

    public long getInputVoltage() {
        return GTValues.V[9];
    }

    public long getEnergyStored() {
        return Numbers.toLong(this.energy);
    }

    public long getEnergyCapacity() {
        return Numbers.toLong(this.energy);
    }
}

