/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.util;

import com.tictim.ceu.mte.MTECeu;
import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class CeuCraftingHelper {
    public static final CeuCraftingHelper HELPER = new CeuCraftingHelper();
    private ItemStack[] hulls;
    private Object[] circuits;
    private UnificationEntry[][] wires;
    private UnificationEntry[] redCables;
    private UnificationEntry[][] cables;

    public Consumer<MTECeu> logic(RecipeFunction function) {
        return ceu -> {
            Object[] objs = function.createRecipe(ceu.getTier(), ceu.getSize());
            if (objs != null) {
                ModHandler.addShapedRecipe((String)ceu.metaTileEntityId.toString(), (ItemStack)ceu.getStackForm(), (Object[])objs);
            }
        };
    }

    public ItemStack hull(int tier) {
        if (this.hulls == null) {
            this.hulls = new ItemStack[MetaTileEntities.HULL.length];
            for (int i = 0; i < this.hulls.length; ++i) {
                this.hulls[i] = MetaTileEntities.HULL[i].getStackForm();
            }
        }
        return this.hulls[tier];
    }

    public Object circuit(int tier) {
        if (this.circuits == null) {
            this.circuits = new Object[GTValues.V.length];
            for (int i = 0; i < GTValues.V.length; ++i) {
                this.circuits[i] = CeuCraftingHelper.circuitGTCE(i);
            }
        }
        return this.circuits[tier];
    }

    private static Object circuitGTCE(int tier) {
        switch (tier) {
            case 0: {
                return new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Primitive);
            }
            case 1: {
                return new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Basic);
            }
            case 2: {
                return new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Good);
            }
            case 3: {
                return new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Advanced);
            }
            case 4: {
                return new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Extreme);
            }
            case 5: {
                return new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Elite);
            }
            case 6: {
                return new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Master);
            }
            case 7: {
                return new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Ultimate);
            }
            case 8: {
                return new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Superconductor);
            }
        }
        return new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.Infinite);
    }

    private static String circuitGA(int i) {
        switch (i) {
            case 0: {
                return "circuitGAPrimitive";
            }
            case 1: {
                return "circuitGABasic";
            }
            case 2: {
                return "circuitGAGood";
            }
            case 3: {
                return "circuitGAAdvanced";
            }
            case 4: {
                return "circuitGAExtreme";
            }
            case 5: {
                return "circuitGAElite";
            }
            case 6: {
                return "circuitGAMaster";
            }
            case 7: {
                return "circuitGAUltimate";
            }
            case 8: {
                return "circuitGASuperconductor";
            }
        }
        return "circuitGAInfinite";
    }

    public UnificationEntry wire(int tier, int stack) {
        if (this.wires == null) {
            this.wires = new UnificationEntry[GTValues.V.length][4];
            for (int t = 0; t < this.wires.length; ++t) {
                for (int s = 0; s < 4; ++s) {
                    this.wires[t][s] = new UnificationEntry(this.prefixWire(s + 1), this.cableMaterialByTier(t));
                }
            }
        }
        return this.wires[tier][stack - 1];
    }

    public UnificationEntry redCable(int stack) {
        if (this.redCables == null) {
            this.redCables = new UnificationEntry[4];
            for (int slot = 0; slot < 4; ++slot) {
                this.redCables[slot] = new UnificationEntry(this.prefixCable(slot + 1), (Material)Materials.RedAlloy);
            }
        }
        return this.redCables[stack - 1];
    }

    public UnificationEntry cable(int tier, int stack) {
        if (this.cables == null) {
            this.cables = new UnificationEntry[GTValues.V.length][4];
            for (int t = 0; t < this.cables.length; ++t) {
                for (int s = 0; s < 4; ++s) {
                    this.cables[t][s] = new UnificationEntry(this.prefixCable(s + 1), this.cableMaterialByTier(t));
                }
            }
        }
        return this.cables[tier][stack - 1];
    }

    public Material cableMaterialByTier(int tier) {
        switch (tier) {
            case 0: {
                return Materials.Lead;
            }
            case 1: {
                return Materials.Tin;
            }
            case 2: {
                return Materials.Copper;
            }
            case 3: {
                return Materials.Gold;
            }
            case 4: {
                return Materials.Aluminium;
            }
            case 5: {
                return Materials.Tungsten;
            }
            case 6: {
                return Materials.VanadiumGallium;
            }
            case 7: {
                return Materials.Naquadah;
            }
            case 8: {
                return Materials.NaquadahAlloy;
            }
        }
        return MarkerMaterials.Tier.Superconductor;
    }

    public OrePrefix prefixCable(int stack) {
        switch (stack) {
            case 1: {
                return OrePrefix.cableGtSingle;
            }
            case 2: {
                return OrePrefix.cableGtQuadruple;
            }
            case 3: {
                return OrePrefix.cableGtOctal;
            }
        }
        return OrePrefix.cableGtHex;
    }

    public OrePrefix prefixWire(int stack) {
        switch (stack) {
            case 1: {
                return OrePrefix.wireGtSingle;
            }
            case 2: {
                return OrePrefix.wireGtQuadruple;
            }
            case 3: {
                return OrePrefix.wireGtOctal;
            }
        }
        return OrePrefix.wireGtHex;
    }

    @FunctionalInterface
    public static interface RecipeFunction {
        @Nullable
        public Object[] createRecipe(int var1, int var2);
    }
}

