/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.fluid;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.shadowfacts.shadowmc.fluid.FluidTank;

public class EntityFluidTank
extends FluidTank {
    protected DataParameter<Integer> amount;
    protected DataParameter<Integer> capacity;
    protected DataParameter<String> name;
    protected EntityDataManager dataManager;

    public EntityFluidTank(EntityDataManager dataManager, DataParameter<Integer> amount, DataParameter<Integer> capacity, DataParameter<String> name, FluidStack stack, int tankCapacity) {
        super(tankCapacity);
        this.dataManager = dataManager;
        this.amount = amount;
        this.capacity = capacity;
        this.name = name;
        dataManager.func_187214_a(capacity, (Object)0);
        dataManager.func_187214_a(amount, (Object)0);
        dataManager.func_187214_a(name, (Object)"");
        this.setCapacity(tankCapacity);
        this.setFluid(stack);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        FluidStack fluid = this.getFluid();
        if (fluid != null) {
            fluid.writeToNBT(tag);
        } else {
            tag.func_74778_a("Empty", "");
        }
        return tag;
    }

    @Override
    public FluidTank readFromNBT(NBTTagCompound tag) {
        if (!tag.func_74764_b("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
            this.setFluid(fluid);
        } else {
            this.setFluid(null);
        }
        return this;
    }

    private String getFluidName() {
        return (String)this.dataManager.func_187225_a(this.name);
    }

    private Fluid getFluidFromDataWatcher() {
        String name = this.getFluidName();
        if (!name.isEmpty()) {
            return FluidRegistry.getFluid((String)name);
        }
        return null;
    }

    private void setFluidName(String name) {
        this.dataManager.func_187227_b(this.name, (Object)name);
    }

    private void setFluidAmount(int amount) {
        this.dataManager.func_187227_b(this.amount, (Object)amount);
    }

    public void setCapacity(int capacity) {
        this.dataManager.func_187227_b(this.capacity, (Object)capacity);
    }

    public void setFluid(FluidStack fluid) {
        if (fluid != null) {
            this.setFluidAmount(fluid.amount);
            this.setFluidName(FluidRegistry.getFluidName((FluidStack)fluid));
        } else {
            this.setFluidAmount(0);
            this.setFluidName("");
        }
    }

    public FluidStack getFluid() {
        Fluid fluid = this.getFluidFromDataWatcher();
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, this.getFluidAmount());
    }

    public int getFluidAmount() {
        return (Integer)this.dataManager.func_187225_a(this.amount);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (this.getFluid() == null) {
                return Math.min(this.getCapacity(), resource.amount);
            }
            if (!this.getFluid().isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.getCapacity() - this.getFluidAmount(), resource.amount);
        }
        if (this.getFluid() == null) {
            this.setFluid(new FluidStack(resource, Math.min(this.getCapacity(), resource.amount)));
            return this.getFluidAmount();
        }
        if (!this.getFluid().isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.getCapacity() - this.getFluidAmount();
        if (resource.amount < filled) {
            this.setFluidAmount(this.getFluidAmount() + resource.amount);
            filled = resource.amount;
        } else {
            this.setFluidAmount(this.getCapacity());
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getFluid() == null) {
            return null;
        }
        int drained = maxDrain;
        if (this.getFluidAmount() < drained) {
            drained = this.getFluidAmount();
        }
        FluidStack stack = new FluidStack(this.getFluid(), drained);
        if (doDrain) {
            this.setFluidAmount(this.getFluidAmount() - drained);
            if (this.getFluidAmount() <= 0) {
                this.setFluid(null);
            }
        }
        return stack;
    }
}

