/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.jei;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.util.BlockInfo;
import gregtech.common.blocks.MetaBlocks;
import gregtech.integration.jei.multiblock.MultiblockShapeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class GAMultiblockShapeInfo
extends MultiblockShapeInfo {
    private final BlockInfo[][][] blocks;

    public GAMultiblockShapeInfo(BlockInfo[][][] blocks) {
        super(blocks);
        this.blocks = blocks;
    }

    public BlockInfo[][][] getBlocks() {
        return this.blocks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends MultiblockShapeInfo.Builder {
        private List<String[]> shape = new ArrayList<String[]>();
        private Map<Character, BlockInfo> symbolMap = new HashMap<Character, BlockInfo>();

        public Builder aisle(String ... data) {
            this.shape.add(data);
            return this;
        }

        public Builder where(char symbol, BlockInfo value) {
            this.symbolMap.put(Character.valueOf(symbol), value);
            return this;
        }

        public Builder where(char symbol, IBlockState blockState) {
            return this.where(symbol, new BlockInfo(blockState));
        }

        public Builder where(char symbol, MetaTileEntity tileEntity, EnumFacing frontSide) {
            MetaTileEntityHolder holder = new MetaTileEntityHolder();
            holder.setMetaTileEntity(tileEntity);
            holder.getMetaTileEntity().setFrontFacing(frontSide);
            return this.where(symbol, new BlockInfo(MetaBlocks.MACHINE.func_176223_P(), (TileEntity)holder));
        }

        private BlockInfo[][][] bakeArray() {
            BlockInfo[][][] blockInfos = new BlockInfo[this.shape.size()][][];
            for (int i = 0; i < blockInfos.length; ++i) {
                String[] aisleEntry = this.shape.get(i);
                BlockInfo[][] aisleData = new BlockInfo[aisleEntry.length][];
                for (int j = 0; j < aisleData.length; ++j) {
                    String columnEntry = aisleEntry[j];
                    BlockInfo[] columnData = new BlockInfo[columnEntry.length()];
                    for (int k = 0; k < columnData.length; ++k) {
                        columnData[k] = this.symbolMap.getOrDefault(Character.valueOf(columnEntry.charAt(k)), BlockInfo.EMPTY);
                        if (columnData[k].getTileEntity() == null || !(columnData[k].getTileEntity() instanceof MetaTileEntityHolder)) continue;
                        MetaTileEntityHolder holder = (MetaTileEntityHolder)columnData[k].getTileEntity();
                        MetaTileEntityHolder newHolder = new MetaTileEntityHolder();
                        newHolder.setMetaTileEntity(holder.getMetaTileEntity().createMetaTileEntity(newHolder));
                        newHolder.getMetaTileEntity().setFrontFacing(holder.getMetaTileEntity().getFrontFacing());
                        columnData[k] = new BlockInfo(columnData[k].getBlockState(), (TileEntity)newHolder);
                    }
                    aisleData[j] = columnData;
                }
                blockInfos[i] = aisleData;
            }
            return blockInfos;
        }

        public GAMultiblockShapeInfo build() {
            return new GAMultiblockShapeInfo(this.bakeArray());
        }
    }
}

