/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.config;

import java.io.File;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xt9.deepmoblearning.DeepConstants;
import xt9.deepmoblearning.common.config.DMLConfiguration;

@Mod.EventBusSubscriber
public class Config {
    private static Configuration config = new DMLConfiguration(new File("config/deepmoblearning.cfg"));
    public static ConfigCategory dataModel = new ConfigCategory("data model simulation costs");
    public static ConfigCategory dataModelMobNames = new ConfigCategory("data model mob names");
    public static ConfigCategory pristineChance = new ConfigCategory("pristine matter chance");
    public static ConfigCategory modelExperience = new ConfigCategory("model experience tweaks");
    public static ConfigCategory pristineOutputs = new ConfigCategory("pristine output items");
    public static ConfigCategory livingMatterEXP = new ConfigCategory("matter experience");
    public static ConfigCategory trialRewards = new ConfigCategory("trial max tier rewards");
    public static Property rfCostExtractionChamber;
    public static Property isSootedRedstoneCraftingEnabled;
    public static Property isGlitchArmorCreativeFlightEnabled;
    public static Property guiOverlaySide;
    public static Property guiOverlayVerticalSpacing;
    public static Property guiOverlayHorizontalSpacing;

    public static void load() {
        config.load();
    }

    public static void initConfigValues() {
        Config.initLivingMatterEXP();
        Config.initDataModelRFCost();
        Config.initDataModelMobs();
        Config.initPristineChance();
        Config.initModelExperience();
        Config.initPristineOutputs();
        Config.initTrialRewards();
        rfCostExtractionChamber = config.get("general", "rfCostLootFabricator", 256, "RF/t cost for the Loot Fabricator, roof is 18k RF/t");
        isSootedRedstoneCraftingEnabled = config.get("general", "isSootedRedstoneCraftingEnabled", true, "Enable the Crafting of sooted redstone on Vanilla blocks of coal");
        isGlitchArmorCreativeFlightEnabled = config.get("general", "isGlitchArmorCreativeFlightEnabled", true, "Set to false to disable the creative flight portion of the Glitch armorset.");
        guiOverlaySide = config.get("general", "guiOverlaySide", "topleft", "Which position on the screen the Deep learner gui will appear on. (bottomleft will clash with the chat) [values: topleft/topright/bottomleft/bottomright]");
        guiOverlayVerticalSpacing = config.get("general", "guiOverlayVerticalSpacing", 0, "Vertical spacing from the selected corner, values can be both positive and negative");
        guiOverlayHorizontalSpacing = config.get("general", "guiOverlayHorizontalSpacing", 0, "Horizontal spacing from the selected corner, values can be both positive and negative");
        config.save();
    }

    private static void initLivingMatterEXP() {
        livingMatterEXP.setComment("Experience values for the different \"realm\" matters, maxValue: 999");
        config.setCategoryComment(livingMatterEXP.getName(), livingMatterEXP.getComment());
        livingMatterEXP.put("overworldian", config.get(livingMatterEXP.getName(), "overworldian", 10, null, 1, 999));
        livingMatterEXP.put("hellish", config.get(livingMatterEXP.getName(), "hellish", 14, null, 1, 999));
        livingMatterEXP.put("extraterrestrial", config.get(livingMatterEXP.getName(), "extraterrestrial", 20, null, 1, 999));
        if (DeepConstants.MOD_TWILIGHT_LOADED) {
            livingMatterEXP.put("twilight", config.get(livingMatterEXP.getName(), "twilight", 30, null, 1, 999));
        }
    }

    private static void initDataModelRFCost() {
        dataModel.setComment("Simulation costs for all the data models (in RF/t)\nCost should not exceed a full machine buffer (Max 6666 RF/t)\nValues over the max will be set to the max");
        config.setCategoryComment(dataModel.getName(), dataModel.getComment());
        dataModel.put("zombie", config.get(dataModel.getName(), "zombie", 80, null, 1, 6666));
        dataModel.put("skeleton", config.get(dataModel.getName(), "skeleton", 80, null, 1, 6666));
        dataModel.put("blaze", config.get(dataModel.getName(), "blaze", 256, null, 1, 6666));
        dataModel.put("enderman", config.get(dataModel.getName(), "enderman", 512, null, 1, 6666));
        dataModel.put("wither", config.get(dataModel.getName(), "wither", 2048, null, 1, 6666));
        dataModel.put("witch", config.get(dataModel.getName(), "witch", 120, null, 1, 6666));
        dataModel.put("spider", config.get(dataModel.getName(), "spider", 80, null, 1, 6666));
        dataModel.put("creeper", config.get(dataModel.getName(), "creeper", 80, null, 1, 6666));
        dataModel.put("ghast", config.get(dataModel.getName(), "ghast", 372, null, 1, 6666));
        dataModel.put("slime", config.get(dataModel.getName(), "slime", 150, null, 1, 6666));
        dataModel.put("dragon", config.get(dataModel.getName(), "dragon", 2560, null, 1, 6666));
        dataModel.put("shulker", config.get(dataModel.getName(), "shulker", 256, null, 1, 6666));
        dataModel.put("guardian", config.get(dataModel.getName(), "guardian", 340, null, 1, 6666));
        dataModel.put("witherskeleton", config.get(dataModel.getName(), "witherskeleton", 880, null, 1, 6666));
        if (DeepConstants.MOD_TE_LOADED) {
            dataModel.put("thermalelemental", config.get(dataModel.getName(), "thermalelemental", 256, null, 1, 6666));
        }
        if (DeepConstants.MOD_TWILIGHT_LOADED) {
            dataModel.put("twilightforest", config.get(dataModel.getName(), "twilightforest", 256, null, 1, 6666));
            dataModel.put("twilightswamp", config.get(dataModel.getName(), "twilightswamp", 256, null, 1, 6666));
            dataModel.put("twilightdarkwood", config.get(dataModel.getName(), "twilightdarkwood", 256, null, 1, 6666));
            dataModel.put("twilightglacier", config.get(dataModel.getName(), "twilightglacier", 256, null, 1, 6666));
        }
        if (DeepConstants.MOD_TCON_LOADED) {
            dataModel.put("tinkerslime", config.get(dataModel.getName(), "tinkerslime", 256, null, 1, 6666));
        }
        if (DeepConstants.MOD_MO_LOADED) {
            dataModel.put("mo_android", config.get(dataModel.getName(), "mo_android", 256, null, 1, 6666));
        }
    }

    private static void initDataModelMobs() {
        dataModelMobNames.setComment("Register entities that count towards leveling up the model\nFormat is modname:entity_name");
        config.setCategoryComment(dataModelMobNames.getName(), dataModelMobNames.getComment());
        dataModelMobNames.put("zombie", new Property("zombie", config.getStringList("zombie", dataModelMobNames.getName(), DeepConstants.MOBS.ZOMBIE, "Zombie"), Property.Type.STRING));
        dataModelMobNames.put("skeleton", new Property("skeleton", config.getStringList("skeleton", dataModelMobNames.getName(), DeepConstants.MOBS.SKELETON, "Creeper"), Property.Type.STRING));
        dataModelMobNames.put("blaze", new Property("blaze", config.getStringList("blaze", dataModelMobNames.getName(), DeepConstants.MOBS.BLAZE, "Blaze"), Property.Type.STRING));
        dataModelMobNames.put("enderman", new Property("enderman", config.getStringList("enderman", dataModelMobNames.getName(), DeepConstants.MOBS.ENDERMAN, "Enderman"), Property.Type.STRING));
        dataModelMobNames.put("wither", new Property("wither", config.getStringList("wither", dataModelMobNames.getName(), DeepConstants.MOBS.WITHER, "Wither"), Property.Type.STRING));
        dataModelMobNames.put("witch", new Property("witch", config.getStringList("witch", dataModelMobNames.getName(), DeepConstants.MOBS.WITCH, "Witch"), Property.Type.STRING));
        dataModelMobNames.put("spider", new Property("spider", config.getStringList("spider", dataModelMobNames.getName(), DeepConstants.MOBS.SPIDER, "Spider"), Property.Type.STRING));
        dataModelMobNames.put("creeper", new Property("creeper", config.getStringList("creeper", dataModelMobNames.getName(), DeepConstants.MOBS.CREEPER, "Creeper"), Property.Type.STRING));
        dataModelMobNames.put("ghast", new Property("ghast", config.getStringList("ghast", dataModelMobNames.getName(), DeepConstants.MOBS.GHAST, "Ghast"), Property.Type.STRING));
        dataModelMobNames.put("slime", new Property("slime", config.getStringList("slime", dataModelMobNames.getName(), DeepConstants.MOBS.SLIME, "Slime"), Property.Type.STRING));
        dataModelMobNames.put("dragon", new Property("dragon", config.getStringList("dragon", dataModelMobNames.getName(), DeepConstants.MOBS.DRAGON, "Dragon"), Property.Type.STRING));
        dataModelMobNames.put("shulker", new Property("shulker", config.getStringList("shulker", dataModelMobNames.getName(), DeepConstants.MOBS.SHULKER, "Shulker"), Property.Type.STRING));
        dataModelMobNames.put("guardian", new Property("guardian", config.getStringList("guardian", dataModelMobNames.getName(), DeepConstants.MOBS.GUARDIAN, "Guardian"), Property.Type.STRING));
        dataModelMobNames.put("witherskeleton", new Property("witherskeleton", config.getStringList("witherskeleton", dataModelMobNames.getName(), DeepConstants.MOBS.WITHERSKELETON, "Wither Skeleton"), Property.Type.STRING));
        if (DeepConstants.MOD_TE_LOADED) {
            dataModelMobNames.put("thermalelemental", new Property("thermalelemental", config.getStringList("thermalelemental", dataModelMobNames.getName(), DeepConstants.MOBS.THERMALELEMENTAL, "Thermal Elemental"), Property.Type.STRING));
        }
        if (DeepConstants.MOD_TWILIGHT_LOADED) {
            dataModelMobNames.put("twilightforest", new Property("twilightforest", config.getStringList("twilightforest", dataModelMobNames.getName(), DeepConstants.MOBS.TWILIGHTFOREST, "Twilight Forest(Biome, not the whole mod)"), Property.Type.STRING));
            dataModelMobNames.put("twilightswamp", new Property("twilightswamp", config.getStringList("twilightswamp", dataModelMobNames.getName(), DeepConstants.MOBS.TWILIGHTSWAMP, "Twilight Swamp creatures"), Property.Type.STRING));
            dataModelMobNames.put("twilightdarkwood", new Property("twilightdarkwood", config.getStringList("twilightdarkwood", dataModelMobNames.getName(), DeepConstants.MOBS.TWILIGHTDARKWOOD, "Twilight Darkwood creatures"), Property.Type.STRING));
            dataModelMobNames.put("twilightglacier", new Property("twilightglacier", config.getStringList("twilightglacier", dataModelMobNames.getName(), DeepConstants.MOBS.TWILIGHTGLACIER, "Twilight Glacier creatures"), Property.Type.STRING));
        }
        if (DeepConstants.MOD_TCON_LOADED) {
            dataModelMobNames.put("tinkerslime", new Property("tinkerslime", config.getStringList("tinkerslime", dataModelMobNames.getName(), DeepConstants.MOBS.TINKERSLIME, "Tinker construct slime"), Property.Type.STRING));
        }
        if (DeepConstants.MOD_MO_LOADED) {
            dataModelMobNames.put("mo_android", new Property("mo_android", config.getStringList("mo_android", dataModelMobNames.getName(), DeepConstants.MOBS.MOAndroid, "Matter Overdrive Androids"), Property.Type.STRING));
        }
    }

    private static void initPristineChance() {
        pristineChance.setComment("The chance to output pristine matter from the various tiers\nStarts at basic since faulty models can't be used in the simulation chamber");
        config.setCategoryComment(pristineChance.getName(), pristineChance.getComment());
        pristineChance.put("tier1", config.get(pristineChance.getName(), "tier1", 5, null, 1, 100));
        pristineChance.put("tier2", config.get(pristineChance.getName(), "tier2", 11, null, 1, 100));
        pristineChance.put("tier3", config.get(pristineChance.getName(), "tier3", 24, null, 1, 100));
        pristineChance.put("tier4", config.get(pristineChance.getName(), "tier4", 42, null, 1, 100));
    }

    private static void initModelExperience() {
        modelExperience.setComment("DISCLAIMER: Please tweak these values responsibly if you're building modpacks for the public, This mods intent is not to be grindy or \"timegated\"\nRemember that a high kill multiplier devalues how much you can use the simulation chamber for leveling\nFor example, a killmultiplier of 100 and 2 required kills to next tier is the equivalent of 200 simulations\nData formula: killmultiplier * requiredKills\nMax multiplier: 100\nMax kills to next tier: 500");
        config.setCategoryComment(modelExperience.getName(), modelExperience.getComment());
        modelExperience.put("killMultiplierTier0", config.get(modelExperience.getName(), "killMultiplierTier0", 1, "How much data you get per kill on the Faulty tier (It's Best to leave this at 1, as a baseline)", 1, 100));
        modelExperience.put("killMultiplierTier1", config.get(modelExperience.getName(), "killMultiplierTier1", 4, "How much data you get per kill on the Basic tier", 1, 100));
        modelExperience.put("killMultiplierTier2", config.get(modelExperience.getName(), "killMultiplierTier2", 10, "How much data you get per kill on the Advanced tier", 1, 100));
        modelExperience.put("killMultiplierTier3", config.get(modelExperience.getName(), "killMultiplierTier3", 18, "How much data you get per kill on the Superior tier", 1, 100));
        modelExperience.put("killsToTier1", config.get(modelExperience.getName(), "killsToTier1", 6, "Number of kills to reach the Basic tier.", 1, 500));
        modelExperience.put("killsToTier2", config.get(modelExperience.getName(), "killsToTier2", 12, "Number of kills to reach the Advanced tier.", 1, 500));
        modelExperience.put("killsToTier3", config.get(modelExperience.getName(), "killsToTier3", 30, "Number of kills to reach the Superior tier.", 1, 500));
        modelExperience.put("killsToTier4", config.get(modelExperience.getName(), "killsToTier4", 50, "Number of kills to reach the Self Aware tier.", 1, 500));
    }

    private static void initPristineOutputs() {
        pristineOutputs.setComment("Entries for Loot fabricator outputs from the different pristine items.\nInput format \"minecraft:coal,64,0\"\nWhere minecraft:coal is the registryName, 64 is the amount and 0 is the damagevalue/meta. \",\" is the delimiter.\nOptionally supports NBT tags, example:\ndeepmoblearning:glitch_infused_sword,1,0,{display:{Name:\"Not a sword really\"}}");
        config.setCategoryComment(pristineOutputs.getName(), pristineOutputs.getComment());
        pristineOutputs.put("blaze", new Property("blaze", config.getStringList("blaze", pristineOutputs.getName(), DeepConstants.LOOT.BLAZE, "Blaze"), Property.Type.STRING));
        pristineOutputs.put("creeper", new Property("creeper", config.getStringList("creeper", pristineOutputs.getName(), DeepConstants.LOOT.CREEPER, "Creeper"), Property.Type.STRING));
        pristineOutputs.put("dragon", new Property("dragon", config.getStringList("dragon", pristineOutputs.getName(), DeepConstants.LOOT.DRAGON, "Dragon"), Property.Type.STRING));
        pristineOutputs.put("enderman", new Property("enderman", config.getStringList("enderman", pristineOutputs.getName(), DeepConstants.LOOT.ENDERMAN, "Enderman"), Property.Type.STRING));
        pristineOutputs.put("ghast", new Property("ghast", config.getStringList("ghast", pristineOutputs.getName(), DeepConstants.LOOT.GHAST, "Ghast"), Property.Type.STRING));
        pristineOutputs.put("skeleton", new Property("skeleton", config.getStringList("skeleton", pristineOutputs.getName(), DeepConstants.LOOT.SKELETON, "Skeleton"), Property.Type.STRING));
        pristineOutputs.put("slime", new Property("slime", config.getStringList("slime", pristineOutputs.getName(), DeepConstants.LOOT.SLIME, "Slime"), Property.Type.STRING));
        pristineOutputs.put("spider", new Property("spider", config.getStringList("spider", pristineOutputs.getName(), DeepConstants.LOOT.SPIDER, "Spider"), Property.Type.STRING));
        pristineOutputs.put("witch", new Property("witch", config.getStringList("witch", pristineOutputs.getName(), DeepConstants.LOOT.WITCH, "Witch"), Property.Type.STRING));
        pristineOutputs.put("witherskeleton", new Property("witherskeleton", config.getStringList("witherskeleton", pristineOutputs.getName(), DeepConstants.LOOT.WITHERSKELETON, "Wither Skeleton"), Property.Type.STRING));
        pristineOutputs.put("wither", new Property("wither", config.getStringList("wither", pristineOutputs.getName(), DeepConstants.LOOT.WITHER, "Wither"), Property.Type.STRING));
        pristineOutputs.put("zombie", new Property("zombie", config.getStringList("zombie", pristineOutputs.getName(), DeepConstants.LOOT.ZOMBIE, "Zombie"), Property.Type.STRING));
        pristineOutputs.put("shulker", new Property("shulker", config.getStringList("shulker", pristineOutputs.getName(), DeepConstants.LOOT.SHULKER, "Shulker"), Property.Type.STRING));
        pristineOutputs.put("guardian", new Property("guardian", config.getStringList("guardian", pristineOutputs.getName(), DeepConstants.LOOT.GUARDIAN, "Guardian"), Property.Type.STRING));
        if (DeepConstants.MOD_TE_LOADED) {
            pristineOutputs.put("thermalelemental", new Property("thermalelemental", config.getStringList("thermalelemental", pristineOutputs.getName(), DeepConstants.LOOT.THERMALELEMENTAL, "Thermal Elemental"), Property.Type.STRING));
        }
        if (DeepConstants.MOD_TCON_LOADED) {
            pristineOutputs.put("tinkerslime", new Property("tinkerslime", config.getStringList("tinkerslime", pristineOutputs.getName(), DeepConstants.LOOT.TINKERSLIME, "Tinker construct slime"), Property.Type.STRING));
        }
        if (DeepConstants.MOD_TWILIGHT_LOADED) {
            pristineOutputs.put("twilightforest", new Property("twilightforest", config.getStringList("twilightforest", pristineOutputs.getName(), DeepConstants.LOOT.TWILIGHTFOREST, "Twilight Forest(Biome, not the whole mod)"), Property.Type.STRING));
            pristineOutputs.put("twilightswamp", new Property("twilightswamp", config.getStringList("twilightswamp", pristineOutputs.getName(), DeepConstants.LOOT.TWILIGHTSWAMP, "Twilight Swamp creatures"), Property.Type.STRING));
            pristineOutputs.put("twilightdarkwood", new Property("twilightdarkwood", config.getStringList("twilightdarkwood", pristineOutputs.getName(), DeepConstants.LOOT.TWILIGHTDARKWOOD, "Twilight Darkwood creatures"), Property.Type.STRING));
            pristineOutputs.put("twilightglacier", new Property("twilightglacier", config.getStringList("twilightglacier", pristineOutputs.getName(), DeepConstants.LOOT.TWILIGHTGLACIER, "Twilight Glacier creatures"), Property.Type.STRING));
        }
        if (DeepConstants.MOD_MO_LOADED) {
            pristineOutputs.put("mo_android", new Property("mo_android", config.getStringList("mo_android", pristineOutputs.getName(), DeepConstants.LOOT.MOAndroid, "Matter Overdrive Androids"), Property.Type.STRING));
        }
    }

    private static void initTrialRewards() {
        trialRewards.setComment("Rewards for the Max tier of trials.\nCAUTION: Max 3 items per list, anything after that will be trimmed. \nInput format \"minecraft:coal,64,0\"\nWhere minecraft:coal is the registryName, 64 is the amount and 0 is the damagevalue/meta. \",\" is the delimiter.\nOptionally supports NBT tags, example:\ndeepmoblearning:glitch_infused_sword,1,0,{display:{Name:\"Not a sword really\"}}");
        config.setCategoryComment(trialRewards.getName(), trialRewards.getComment());
        trialRewards.put("zombie", new Property("zombie", config.getStringList("zombie", trialRewards.getName(), DeepConstants.TRIAL_REWARD.ZOMBIE, "Zombie Trial Reward"), Property.Type.STRING));
        trialRewards.put("enderman", new Property("enderman", config.getStringList("enderman", trialRewards.getName(), DeepConstants.TRIAL_REWARD.ENDERMAN, "Enderman Trial Reward"), Property.Type.STRING));
        trialRewards.put("skeleton", new Property("skeleton", config.getStringList("skeleton", trialRewards.getName(), DeepConstants.TRIAL_REWARD.SKELETON, "Skeleton Trial Reward"), Property.Type.STRING));
        trialRewards.put("witch", new Property("witch", config.getStringList("witch", trialRewards.getName(), DeepConstants.TRIAL_REWARD.WITCH, "Witch Trial Reward"), Property.Type.STRING));
        trialRewards.put("spider", new Property("spider", config.getStringList("spider", trialRewards.getName(), DeepConstants.TRIAL_REWARD.SPIDER, "Spider Trial Reward"), Property.Type.STRING));
        trialRewards.put("slime", new Property("slime", config.getStringList("slime", trialRewards.getName(), DeepConstants.TRIAL_REWARD.SLIME, "Slime Trial Reward"), Property.Type.STRING));
        trialRewards.put("witherskeleton", new Property("witherskeleton", config.getStringList("witherskeleton", trialRewards.getName(), DeepConstants.TRIAL_REWARD.WITHERSKELETON, "Slime Trial Reward"), Property.Type.STRING));
    }

    @SubscribeEvent
    public static void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("deepmoblearning")) {
            Config.initConfigValues();
        }
    }

    public static class LootParser {
        public static NonNullList<ItemStack> getTrialRewards(String key) {
            NonNullList list = NonNullList.func_191196_a();
            if (!trialRewards.containsKey(key)) {
                return list;
            }
            String[] toParseList = trialRewards.get(key).getStringList();
            for (int i = 0; i < toParseList.length; ++i) {
                if (LootParser.getStackFromConfigLine(toParseList[i]).func_190926_b()) continue;
                list.add((Object)LootParser.getStackFromConfigLine(toParseList[i]));
            }
            return list;
        }

        public static NonNullList<ItemStack> getPristineLootEntries(String key) {
            NonNullList list = NonNullList.func_191196_a();
            if (!pristineOutputs.containsKey(key)) {
                return list;
            }
            String[] toParseList = pristineOutputs.get(key).getStringList();
            for (int i = 0; i < toParseList.length; ++i) {
                if (LootParser.getStackFromConfigLine(toParseList[i]).func_190926_b()) continue;
                list.add((Object)LootParser.getStackFromConfigLine(toParseList[i]));
            }
            return list;
        }

        private static ItemStack getStackFromConfigLine(String line) {
            Item item;
            int meta;
            int amount;
            String[] vals = line.split(",");
            if (vals.length < 3) {
                return ItemStack.field_190927_a;
            }
            String itemName = vals[0];
            NBTTagCompound nbt = null;
            try {
                amount = Integer.parseInt(vals[1]);
                meta = Integer.parseInt(vals[2]);
            }
            catch (NumberFormatException e) {
                System.out.println("Not a valid number for meta or amount");
                return ItemStack.field_190927_a;
            }
            if (vals.length > 3) {
                StringBuilder nbtString = new StringBuilder();
                for (int i = 3; i < vals.length; ++i) {
                    nbtString.append(vals[i]);
                    nbtString.append(i == vals.length - 1 ? "" : ",");
                }
                try {
                    nbt = JsonToNBT.func_180713_a((String)nbtString.toString());
                }
                catch (NBTException e) {
                    e.printStackTrace();
                    return ItemStack.field_190927_a;
                }
            }
            if ((item = Item.func_111206_d((String)itemName)) != null && nbt != null) {
                ItemStack nbtStack = new ItemStack(item, amount, meta);
                nbtStack.func_77982_d(nbt);
                return nbtStack;
            }
            if (item != null) {
                return new ItemStack(item, amount, meta);
            }
            return ItemStack.field_190927_a;
        }
    }
}

