/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import xt9.deepmoblearning.common.handlers.BaseItemHandler;
import xt9.deepmoblearning.common.inventory.SlotDeepLearner;
import xt9.deepmoblearning.common.items.ItemDeepLearner;

public class ContainerDeepLearner
extends Container {
    protected BaseItemHandler handler;
    protected EntityEquipmentSlot equipmentSlot;
    protected World world;
    protected EntityPlayer player;
    protected ItemStack deepLearner;
    protected int internalSlots = 4;
    protected int deepLearnerSlot;

    public ContainerDeepLearner(InventoryPlayer inventory, World world, EntityEquipmentSlot slot, ItemStack heldItem) {
        this.handler = new BaseItemHandler(ItemDeepLearner.getContainedItems(heldItem));
        this.deepLearnerSlot = inventory.field_70461_c + this.internalSlots;
        this.deepLearner = heldItem;
        this.world = world;
        this.player = inventory.field_70458_d;
        this.equipmentSlot = slot;
        this.addDataModelSlots();
        this.addInventorySlots();
    }

    private void addDataModelSlots() {
        this.func_75146_a((Slot)new SlotDeepLearner((IItemHandler)this.handler, 0, 257, 100));
        this.func_75146_a((Slot)new SlotDeepLearner((IItemHandler)this.handler, 1, 275, 100));
        this.func_75146_a((Slot)new SlotDeepLearner((IItemHandler)this.handler, 2, 257, 118));
        this.func_75146_a((Slot)new SlotDeepLearner((IItemHandler)this.handler, 3, 275, 118));
    }

    private void addInventorySlots() {
        int row;
        for (row = 0; row < 9; ++row) {
            int index = row;
            Slot slot = new Slot((IInventory)this.player.field_71071_by, index, 89 + row * 18, 211);
            this.func_75146_a(slot);
        }
        for (row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int x = 89 + column * 18;
                int y = 153 + row * 18;
                int index = column + row * 9 + 9;
                Slot slot = new Slot((IInventory)this.player.field_71071_by, index, x, y);
                this.func_75146_a(slot);
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? !this.func_75135_a(itemstack1, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        this.updateInventories();
        return itemstack;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId == this.deepLearnerSlot && !this.equipmentSlot.func_188450_d().equals("offhand") || clickTypeIn == ClickType.SWAP && dragType == player.field_71071_by.field_70461_c) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        this.updateInventories();
        return stack;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.updateInventories();
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return !this.player.func_175149_v();
    }

    private void updateInventories() {
        ItemDeepLearner.setContainedItems(this.deepLearner, this.handler.getItemStacks());
        ItemStack hand = this.player.func_184582_a(this.equipmentSlot);
        if (!hand.func_190926_b() && !hand.equals(this.deepLearner)) {
            this.player.func_184201_a(this.equipmentSlot, this.deepLearner);
        }
        this.player.field_71071_by.func_70296_d();
    }
}

