/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.trials;

import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import xt9.deepmoblearning.common.mobmetas.MobMetaData;
import xt9.deepmoblearning.common.mobmetas.MobMetaFactory;

public abstract class Trial {
    protected String mobKey;
    protected MobMetaData data;
    protected int[] mobsPerWave;

    public Trial(String mobKey, int[] mobsPerWave) {
        this.mobKey = mobKey;
        this.data = MobMetaFactory.createMobMetaData(mobKey);
        this.mobsPerWave = mobsPerWave;
    }

    public String getMobKey() {
        return this.mobKey;
    }

    public int getMobCountForWave(int wave) {
        if (wave > this.mobsPerWave.length - 1) {
            return 0;
        }
        return this.mobsPerWave[wave];
    }

    public MobMetaData getData() {
        return this.data;
    }

    public abstract EntityLiving getTrialPrimaryEntity(World var1);

    public abstract NonNullList<ItemStack> getTrialRewards(int var1);

    public double getSpawnDelay() {
        return 2.0;
    }
}

