/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.util;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xt9.deepmoblearning.DeepMobLearning;
import xt9.deepmoblearning.common.capabilities.IPlayerTrial;
import xt9.deepmoblearning.common.capabilities.PlayerTrial;
import xt9.deepmoblearning.common.capabilities.PlayerTrialProvider;
import xt9.deepmoblearning.common.items.ItemDeepLearner;
import xt9.deepmoblearning.common.network.UpdateTrialOverlayMessage;

public class PlayerHelper {
    private boolean isHoldingDeepLearner;
    private EntityPlayer player;
    private ItemStack stack;

    public static List<EntityPlayerMP> getPlayersInArea(World world, BlockPos pos, int area, int yStart, int yEnd) {
        BlockPos point1 = new BlockPos(pos.func_177958_n() - area, yStart, pos.func_177952_p() - area);
        BlockPos point2 = new BlockPos(pos.func_177958_n() + area, yEnd, pos.func_177952_p() + area);
        return world.func_175647_a(EntityPlayerMP.class, new AxisAlignedBB(point1, point2), p -> !p.field_70128_L);
    }

    public static IPlayerTrial getTrialCapability(EntityPlayerMP player) {
        if (PlayerTrialProvider.PLAYER_TRIAL_CAP != null) {
            return (IPlayerTrial)player.getCapability(PlayerTrialProvider.PLAYER_TRIAL_CAP, null);
        }
        return new PlayerTrial();
    }

    public static void sendMessageToOverlay(EntityPlayerMP player, String type) {
        if (player != null) {
            DeepMobLearning.network.sendTo((IMessage)new UpdateTrialOverlayMessage(type), player);
        }
    }

    public static void sendMessage(EntityPlayerMP player, TextComponentString component) {
        if (player != null) {
            player.func_145747_a((ITextComponent)component);
        }
    }

    public static EntityPlayerMP getPlayerFromUUID(UUID uuid) {
        PlayerList list = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        return list.func_177451_a(uuid);
    }

    public PlayerHelper(EntityPlayer player) {
        this.player = player;
        ItemStack mainHandStack = this.player.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offHandStack = this.player.func_184586_b(EnumHand.OFF_HAND);
        if (mainHandStack.func_77973_b() instanceof ItemDeepLearner) {
            this.stack = mainHandStack;
            this.isHoldingDeepLearner = true;
        } else if (offHandStack.func_77973_b() instanceof ItemDeepLearner) {
            this.stack = offHandStack;
            this.isHoldingDeepLearner = true;
        } else {
            this.isHoldingDeepLearner = false;
            this.stack = ItemStack.field_190927_a;
        }
    }

    public boolean isHoldingDeepLearner() {
        return this.isHoldingDeepLearner;
    }

    public ItemStack getHeldDeepLearner() {
        return this.stack;
    }
}

