/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux.block.tile;

import com.zeitheron.solarflux.api.SolarInfo;
import com.zeitheron.solarflux.api.SolarInstance;
import com.zeitheron.solarflux.api.attribute.SimpleAttributeProperty;
import com.zeitheron.solarflux.block.BlockBaseSolar;
import com.zeitheron.solarflux.gui.ContainerBaseSolar;
import com.zeitheron.solarflux.items.ItemUpgrade;
import com.zeitheron.solarflux.utils.BlockPosFace;
import com.zeitheron.solarflux.utils.FByteHelper;
import com.zeitheron.solarflux.utils.IVariableHandler;
import com.zeitheron.solarflux.utils.InventoryDummy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileBaseSolar
extends TileEntity
implements ITickable,
IEnergyStorage,
IVariableHandler {
    public long energy;
    public long currentGeneration;
    public float sunIntensity;
    public SolarInstance instance;
    public boolean renderConnectedTextures = true;
    public List<EntityPlayer> crafters = new ArrayList<EntityPlayer>();
    public final SimpleAttributeProperty generation = new SimpleAttributeProperty();
    public final SimpleAttributeProperty transfer = new SimpleAttributeProperty();
    public final SimpleAttributeProperty capacity = new SimpleAttributeProperty();
    public final InventoryDummy items = new InventoryDummy(5);
    public final InventoryDummy itemChargeable = new InventoryDummy(1);
    public final List<BlockPosFace> traversal = new ArrayList<BlockPosFace>();
    public final InvWrapper itemWrapper = new InvWrapper((IInventory)this.itemChargeable);
    public boolean cache$seeSky;
    public byte cache$seeSkyTimer;
    List<ResourceLocation> tickedUpgrades;
    public boolean setBaseValuesOnGet;

    public TileBaseSolar(SolarInstance instance) {
        this.items.validSlots = (slot, stack) -> {
            if (!(stack.func_77973_b() instanceof ItemUpgrade)) {
                return false;
            }
            return this.getUpgrades(stack.func_77973_b()) < ((ItemUpgrade)stack.func_77973_b()).getMaxUpgrades() && ((ItemUpgrade)stack.func_77973_b()).canInstall(this, (ItemStack)stack, this.items);
        };
        this.itemChargeable.validSlots = (slot, stack) -> {
            IEnergyStorage e;
            return !stack.func_190926_b() && stack.hasCapability(CapabilityEnergy.ENERGY, null) && (e = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).canReceive() && e.getEnergyStored() < e.getMaxEnergyStored();
        };
        this.items.fields = this;
        this.itemChargeable.fields = this;
        this.items.openInv = this.crafters::add;
        this.itemChargeable.openInv = this.crafters::add;
        this.items.closeInv = this.crafters::remove;
        this.itemChargeable.closeInv = this.crafters::remove;
        this.tickedUpgrades = new ArrayList<ResourceLocation>();
        this.setBaseValuesOnGet = true;
        this.instance = instance;
    }

    public TileBaseSolar() {
        this.items.validSlots = (slot, stack) -> {
            if (!(stack.func_77973_b() instanceof ItemUpgrade)) {
                return false;
            }
            return this.getUpgrades(stack.func_77973_b()) < ((ItemUpgrade)stack.func_77973_b()).getMaxUpgrades() && ((ItemUpgrade)stack.func_77973_b()).canInstall(this, (ItemStack)stack, this.items);
        };
        this.itemChargeable.validSlots = (slot, stack) -> {
            IEnergyStorage e;
            return !stack.func_190926_b() && stack.hasCapability(CapabilityEnergy.ENERGY, null) && (e = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).canReceive() && e.getEnergyStored() < e.getMaxEnergyStored();
        };
        this.items.fields = this;
        this.itemChargeable.fields = this;
        this.items.openInv = this.crafters::add;
        this.itemChargeable.openInv = this.crafters::add;
        this.items.closeInv = this.crafters::remove;
        this.itemChargeable.closeInv = this.crafters::remove;
        this.tickedUpgrades = new ArrayList<ResourceLocation>();
        this.setBaseValuesOnGet = true;
    }

    public int getUpgrades(Item type) {
        int c = 0;
        for (int i = 0; i < this.items.func_70302_i_(); ++i) {
            ItemStack stack = this.items.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != type) continue;
            c += stack.func_190916_E();
        }
        return c;
    }

    public boolean isSameLevel(TileBaseSolar other) {
        if (other == null) {
            return false;
        }
        if (other.instance == null || this.instance == null) {
            return false;
        }
        return Objects.equals(other.instance.delegate, this.instance.delegate);
    }

    public boolean doesSeeSky() {
        if (this.cache$seeSkyTimer < 1) {
            this.cache$seeSkyTimer = (byte)20;
            this.cache$seeSky = this.field_145850_b != null && this.field_145850_b.func_175642_b(EnumSkyBlock.SKY, this.field_174879_c) > 0 && this.field_174879_c != null ? this.field_145850_b.func_175710_j(this.field_174879_c) : false;
        }
        return this.cache$seeSky;
    }

    public void tickUpgrades() {
        ItemStack stack;
        this.generation.clearAttributes();
        this.transfer.clearAttributes();
        this.capacity.clearAttributes();
        for (int i = 0; i < this.items.func_70302_i_(); ++i) {
            stack = this.items.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemUpgrade && ((ItemUpgrade)stack.func_77973_b()).canStayInPanel(this, stack, this.items)) {
                ResourceLocation id = stack.func_77973_b().getRegistryName();
                if (this.tickedUpgrades.contains(id)) continue;
                ItemUpgrade iu = (ItemUpgrade)stack.func_77973_b();
                iu.update(this, stack, this.getUpgrades(iu));
                this.tickedUpgrades.add(id);
                continue;
            }
            ItemStack s = this.items.func_70304_b(i);
            s.func_77946_l();
            this.items.func_70299_a(i, ItemStack.field_190927_a);
            if (this.field_145850_b.field_72995_K) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack));
        }
        for (int i = 0; i < this.itemChargeable.func_70302_i_(); ++i) {
            IEnergyStorage e;
            stack = this.itemChargeable.func_70301_a(i);
            if (stack.func_190926_b() || !stack.hasCapability(CapabilityEnergy.ENERGY, null) || !(e = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).canReceive() || e.getEnergyStored() >= e.getMaxEnergyStored()) continue;
            this.transfer.setBaseValue(this.instance.transfer);
            int transfer = this.transfer.getValueI();
            this.energy -= (long)e.receiveEnergy(Math.min(this.getEnergyStored(), transfer), false);
        }
        this.tickedUpgrades.clear();
    }

    public void func_73660_a() {
        if (this.cache$seeSkyTimer > 0) {
            this.cache$seeSkyTimer = (byte)(this.cache$seeSkyTimer - 1);
        }
        if (this.func_145838_q() instanceof BlockBaseSolar) {
            SolarInfo si = ((BlockBaseSolar)this.func_145838_q()).solarInfo;
            this.renderConnectedTextures = si.connectTextures;
            if (si.maxGeneration <= 0L) {
                this.field_145850_b.func_175655_b(this.field_174879_c, true);
                return;
            }
            if (this.instance == null || !this.instance.isValid()) {
                this.instance = new SolarInstance();
                si.accept(this.instance);
                return;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.traversal.clear();
        }
        this.tickUpgrades();
        int gen = this.getGeneration();
        this.capacity.setBaseValue(this.instance.cap);
        this.energy += Math.min(this.capacity.getValueL() - this.energy, (long)gen);
        this.currentGeneration = gen;
        for (int i = 0; i < this.crafters.size(); ++i) {
            try {
                EntityPlayer player = this.crafters.get(i);
                if (player.field_71070_bA instanceof ContainerBaseSolar) {
                    player.field_71070_bA.func_75142_b();
                    continue;
                }
                this.crafters.remove(i);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.energy = Math.min(Math.max(this.energy, 0L), this.capacity.getValueL());
        for (EnumFacing hor : EnumFacing.field_176754_o) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(hor));
            if (!(tile instanceof TileBaseSolar)) continue;
            this.autoBalanceEnergy((TileBaseSolar)tile);
        }
        this.transfer.setBaseValue(this.instance.transfer);
        int transfer = this.transfer.getValueI();
        for (EnumFacing hor : EnumFacing.field_82609_l) {
            IEnergyStorage storage;
            TileEntity tile;
            if (hor == EnumFacing.UP || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(hor))) == null || !tile.hasCapability(CapabilityEnergy.ENERGY, hor.func_176734_d()) || !(storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, hor.func_176734_d())).canReceive()) continue;
            this.energy -= (long)storage.receiveEnergy(Math.min(this.getEnergyStored(), transfer), false);
        }
        if (!this.traversal.isEmpty()) {
            for (BlockPosFace traverse : this.traversal) {
                IEnergyStorage storage;
                TileEntity tile = this.field_145850_b.func_175625_s(traverse.pos);
                if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, traverse.face) || !(storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, traverse.face)).canReceive()) continue;
                this.energy -= (long)storage.receiveEnergy(Math.min(this.getEnergyStored(), Math.round((float)transfer * traverse.rate)), false);
            }
        }
    }

    public int getGeneration() {
        float effUpgrIncr = 0.15f;
        float eff = this.instance.computeSunIntensity(this);
        if (!this.field_145850_b.field_72995_K) {
            this.sunIntensity = eff;
        }
        float energyGeneration = (float)this.instance.gen * eff;
        this.generation.setBaseValue(energyGeneration);
        return this.generation.getValueI();
    }

    public NBTTagCompound write(NBTTagCompound nbt) {
        nbt.func_179237_a(this.instance.serializeNBT());
        nbt.func_74782_a("Items", (NBTBase)this.items.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("ChargeableItem", (NBTBase)this.itemChargeable.writeToNBT(new NBTTagCompound()));
        nbt.func_74772_a("Energy", this.energy);
        return nbt;
    }

    public void read(NBTTagCompound nbt) {
        this.instance = SolarInstance.deserialize(nbt);
        this.items.readFromNBT(nbt.func_74775_l("Items"));
        this.itemChargeable.readFromNBT(nbt.func_74775_l("ChargeableItem"));
        this.energy = nbt.func_74763_f("Energy");
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != EnumFacing.UP) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != EnumFacing.UP) {
            return (T)this;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemWrapper;
        }
        return (T)super.getCapability(capability, facing);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.write(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.read(pkt.func_148857_g());
    }

    public void sync() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 11);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.read(nbt);
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        return super.func_189515_b(this.write(nbt));
    }

    public int autoBalanceEnergy(TileBaseSolar solar) {
        int delta = this.getEnergyStored() - solar.getEnergyStored();
        if (delta < 0) {
            return solar.autoBalanceEnergy(this);
        }
        if (delta > 0) {
            return this.extractEnergy(solar.receiveEnergyInternal(this.extractEnergy(solar.receiveEnergyInternal(delta / 2, true), true), false), false);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        this.transfer.setBaseValue(this.instance.transfer);
        int transfer = this.transfer.getValueI();
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(transfer, maxExtract));
        if (!simulate) {
            this.energy -= (long)energyExtracted;
        }
        return energyExtracted;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int receiveEnergyInternal(int maxReceive, boolean simulate) {
        this.transfer.setBaseValue(this.instance.transfer);
        int transfer = this.transfer.getValueI();
        this.capacity.setBaseValue(this.instance.cap);
        long cap = this.capacity.getValueL();
        int energyReceived = Math.min((int)Math.min(cap - this.energy, Integer.MAX_VALUE), Math.min(transfer, maxReceive));
        if (!simulate) {
            this.energy += (long)energyReceived;
        }
        return energyReceived;
    }

    public int getEnergyStored() {
        return (int)Math.min(this.energy, Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.getVar(1), Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public long getVar(int id) {
        switch (id) {
            case 0: {
                if (this.setBaseValuesOnGet) {
                    this.capacity.setBaseValue(this.instance.cap);
                }
                return this.capacity.getValueL();
            }
            case 1: {
                return this.energy;
            }
            case 2: {
                if (this.setBaseValuesOnGet) {
                    this.generation.setBaseValue(this.instance.gen);
                }
                return this.generation.getValueL();
            }
            case 3: {
                if (this.setBaseValuesOnGet) {
                    this.transfer.setBaseValue(this.instance.transfer);
                }
                return this.transfer.getValueL();
            }
            case 4: {
                return this.currentGeneration;
            }
            case 5: {
                return FByteHelper.toInt(this.sunIntensity);
            }
        }
        return 0L;
    }

    @Override
    public void setVar(int id, long value) {
        switch (id) {
            case 0: {
                this.capacity.setValue(value);
                break;
            }
            case 1: {
                this.energy = Math.min(Math.max(value, 0L), this.capacity.getValueL());
                break;
            }
            case 2: {
                this.generation.setValue(value);
                break;
            }
            case 3: {
                this.transfer.setValue(value);
                break;
            }
            case 4: {
                this.currentGeneration = value;
                break;
            }
            case 5: {
                this.sunIntensity = FByteHelper.toFloat((int)value);
            }
        }
    }

    @Override
    public int getVarCount() {
        return 6;
    }
}

