/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.zeitheron.solarflux.api.SolarFluxAPI;
import com.zeitheron.solarflux.api.SolarInfo;
import com.zeitheron.solarflux.block.BlockBaseSolar;
import com.zeitheron.solarflux.init.SolarsSF;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.Locale;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.IOUtils;

public class SolarFluxResourcePack
implements IResourcePack,
IResourceManagerReloadListener {
    public final Map<ResourceLocation, IResourceStreamSupplier> resourceMap = new HashMap<ResourceLocation, IResourceStreamSupplier>();
    public final Map<String, List<String>> langs = new HashMap<String, List<String>>();
    public final List<SolarInfo> infos = new ArrayList<SolarInfo>();
    public final Set<String> domains = new HashSet<String>();
    boolean calling = false;

    private static IResourceStreamSupplier ofText(String text) {
        return IResourceStreamSupplier.create(() -> true, () -> new ByteArrayInputStream(text.getBytes()));
    }

    private static IResourceStreamSupplier ofFile(File file) {
        return IResourceStreamSupplier.create(file::isFile, () -> new FileInputStream(file));
    }

    public void rebake() {
        this.resourceMap.clear();
        this.langs.clear();
        this.infos.clear();
        this.domains.clear();
        this.domains.addAll(Loader.instance().getIndexedModList().keySet());
        this.domains.remove("minecraft");
        if (SolarFluxAPI.SOLAR_PANELS != null) {
            this.infos.addAll(SolarFluxAPI.SOLAR_PANELS.getValuesCollection());
        }
        if (!this.infos.isEmpty()) {
            this.domains.clear();
        }
        this.domains.addAll(SolarFluxAPI.resourceDomains);
        for (SolarInfo si : this.infos) {
            if (si.localizations != null) {
                for (String lang : si.localizations.keySet()) {
                    String v;
                    List<String> ls = this.langs.get(lang + ".lang");
                    if (ls == null) {
                        ls = new ArrayList<String>();
                        this.langs.put(lang + ".lang", ls);
                    }
                    if (ls.contains(v = si.localizations.get(lang))) continue;
                    ls.add(si.getBlock().func_149739_a() + ".name=" + v);
                }
            }
            BlockBaseSolar blk = si.getBlock();
            ResourceLocation reg = blk.getRegistryName();
            ResourceLocation reg2 = si.getRegistryName();
            this.domains.add(reg.func_110624_b());
            ResourceLocation blockstate = new ResourceLocation(reg.func_110624_b(), "blockstates/" + reg.func_110623_a() + ".json");
            ResourceLocation models_block = new ResourceLocation(reg.func_110624_b(), "models/block/" + reg.func_110623_a() + ".json");
            ResourceLocation models_item = new ResourceLocation(reg.func_110624_b(), "models/item/" + reg.func_110623_a() + ".json");
            int thicc = si.thiccness;
            int reverseThicc = 16 - thicc;
            this.resourceMap.put(blockstate, SolarFluxResourcePack.ofText("{\"variants\":{\"normal\":{\"model\":\"" + reg.toString() + "\"}}}"));
            this.resourceMap.put(models_item, SolarFluxResourcePack.ofText("{\"parent\":\"" + reg.func_110624_b() + ":block/" + reg.func_110623_a() + "\"}"));
            this.resourceMap.put(models_block, SolarFluxResourcePack.ofText("{\"parent\":\"block/block\",\"textures\":{\"side\":\"" + reg.func_110624_b() + ":blocks/solar_base_" + reg2.func_110623_a() + "\",\"particle\":\"" + reg.func_110624_b() + ":blocks/solar_top_" + reg2.func_110623_a() + "\"},\"elements\":[{\"from\":[0, 0, 0],\"to\":[16, " + thicc + ", 16],\"faces\":{\"north\":{\"uv\":[0, " + reverseThicc + ", 16, 16],\"texture\":\"#side\"},\"east\":{\"uv\":[0, " + reverseThicc + ", 16, 16],\"texture\":\"#side\"},\"south\":{\"uv\":[0, " + reverseThicc + ", 16, 16],\"texture\":\"#side\"},\"west\":{\"uv\":[0, " + reverseThicc + ", 16, 16],\"texture\":\"#side\"},\"up\":{\"uv\":[0, 0, 16, 16],\"texture\":\"#particle\"},\"down\":{\"uv\":[0, 0, 16, 16],\"texture\":\"#side\"}}}]}"));
            if (!si.isCustom) continue;
            File customDir = SolarsSF.getCustomCfgDir();
            ResourceLocation textures_blocks_base = new ResourceLocation(reg.func_110624_b(), "textures/blocks/solar_base_" + reg2.func_110623_a() + ".png");
            ResourceLocation textures_blocks_topf = new ResourceLocation(reg.func_110624_b(), "textures/blocks/solar_topf_" + reg2.func_110623_a() + ".png");
            ResourceLocation textures_blocks_top = new ResourceLocation(reg.func_110624_b(), "textures/blocks/solar_top_" + reg2.func_110623_a() + ".png");
            ResourceLocation textures_blocks_base_mcmeta = new ResourceLocation(reg.func_110624_b(), "textures/blocks/solar_base_" + reg2.func_110623_a() + ".png.mcmeta");
            ResourceLocation textures_blocks_topf_mcmeta = new ResourceLocation(reg.func_110624_b(), "textures/blocks/solar_topf_" + reg2.func_110623_a() + ".png.mcmeta");
            ResourceLocation textures_blocks_top_mcmeta = new ResourceLocation(reg.func_110624_b(), "textures/blocks/solar_top_" + reg2.func_110623_a() + ".png.mcmeta");
            File theDir = new File(customDir, reg2.func_110623_a());
            if (!theDir.isDirectory()) continue;
            this.resourceMap.put(textures_blocks_base, SolarFluxResourcePack.ofFile(new File(theDir, "base.png")));
            this.resourceMap.put(textures_blocks_base_mcmeta, SolarFluxResourcePack.ofFile(new File(theDir, "base.mcmeta")));
            this.resourceMap.put(textures_blocks_top, SolarFluxResourcePack.ofFile(new File(theDir, "top.png")));
            this.resourceMap.put(textures_blocks_top_mcmeta, SolarFluxResourcePack.ofFile(new File(theDir, "top.mcmeta")));
            this.resourceMap.put(textures_blocks_topf, SolarFluxResourcePack.ofFile(new File(theDir, "top_full.png")));
            this.resourceMap.put(textures_blocks_topf_mcmeta, SolarFluxResourcePack.ofFile(new File(theDir, "top_full.mcmeta")));
        }
        SolarFluxResourcePack.injectSolarPanelLanguages();
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        if (this.calling) {
            return null;
        }
        this.calling = true;
        try {
            InputStream in = this.resourceMap.get(location).create();
            this.calling = false;
            return in;
        }
        catch (RuntimeException e) {
            this.calling = false;
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public boolean func_110589_b(ResourceLocation location) {
        IResourceStreamSupplier s = this.resourceMap.get(location);
        return s != null && s.exists();
    }

    public Set<String> func_110587_b() {
        return this.domains;
    }

    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        return SolarFluxResourcePack.readMetadata(metadataSerializer, new ByteArrayInputStream("{\"pack\": {\"pack_format\": 1,\"description\": \"External & Generated resources for SolarFluxReborn\"}}".getBytes()), metadataSectionName);
    }

    static <T extends IMetadataSection> T readMetadata(MetadataSerializer metadataSerializer, InputStream p_110596_1_, String sectionName) {
        JsonObject jsonobject = null;
        BufferedReader bufferedreader = null;
        try {
            bufferedreader = new BufferedReader(new InputStreamReader(p_110596_1_, StandardCharsets.UTF_8));
            jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
        }
        catch (RuntimeException runtimeexception) {
            try {
                throw new JsonParseException((Throwable)runtimeexception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedreader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)bufferedreader);
        return (T)metadataSerializer.func_110503_a(sectionName, jsonobject);
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "SolarFluxReborn Builtin";
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.rebake();
        SolarFluxResourcePack.injectSolarPanelLanguages();
    }

    public static void injectSolarPanelLanguages() {
        if (SolarFluxAPI.SOLAR_PANELS == null) {
            return;
        }
        Field i18nLocalef = I18n.class.getDeclaredFields()[0];
        i18nLocalef.setAccessible(true);
        try {
            Locale locale = (Locale)Locale.class.cast(i18nLocalef.get(null));
            Field propertiesf = Locale.class.getDeclaredFields()[2];
            propertiesf.setAccessible(true);
            Map properties = (Map)Map.class.cast(propertiesf.get(locale));
            String code = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
            HashMap langs = new HashMap();
            for (SolarInfo si : SolarFluxAPI.SOLAR_PANELS.getValuesCollection()) {
                if (si.localizations == null) continue;
                for (String lang : si.localizations.keySet()) {
                    String v;
                    ArrayList<String> ls = (ArrayList<String>)langs.get(lang);
                    if (ls == null) {
                        ls = new ArrayList<String>();
                        langs.put(lang, ls);
                    }
                    if (ls.contains(v = si.localizations.get(lang))) continue;
                    ls.add(si.getBlock().func_149739_a() + ".name=" + v);
                }
                if (si.localizations.containsKey("en_us")) {
                    properties.put(si.getBlock().func_149739_a() + ".name", si.localizations.get("en_us"));
                }
                if (!si.localizations.containsKey(code)) continue;
                properties.put(si.getBlock().func_149739_a() + ".name", si.localizations.get(code));
            }
            if (langs.containsKey(code)) {
                StringBuilder sb = new StringBuilder("# Builtin & Generated by Solar Flux Reborn lang file.\n");
                ((List)langs.get(code)).stream().map(ln -> "\n" + ln).forEach(sb::append);
                LanguageMap.inject((InputStream)new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)));
            }
        }
        catch (ReflectiveOperationException err) {
            err.printStackTrace();
        }
    }

    @FunctionalInterface
    public static interface IIOSupplier<T> {
        public T get() throws IOException;
    }

    public static interface IResourceStreamSupplier {
        public static IResourceStreamSupplier create(final BooleanSupplier exists, final IIOSupplier<InputStream> streamable) {
            return new IResourceStreamSupplier(){

                @Override
                public boolean exists() {
                    return exists.getAsBoolean();
                }

                @Override
                public InputStream create() throws IOException {
                    return (InputStream)streamable.get();
                }
            };
        }

        public boolean exists();

        public InputStream create() throws IOException;
    }
}

