/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.client.renderer;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.client.renderer.sky.SkyRenderObject;
import com.bloodnbonesgaming.topography.client.renderer.sky.SkyboxRenderer;
import com.bloodnbonesgaming.topography.client.renderer.sky.SunRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraftforge.client.IRenderHandler;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/SkyRendererCustom", classExplaination="This file is for the SkyRendererCustom. This is for making a custom sky renderer.")
public class SkyRendererCustom
extends IRenderHandler {
    private final List<SkyRenderObject> renderObjects = new ArrayList<SkyRenderObject>();

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        for (SkyRenderObject render : this.renderObjects) {
            render.render(partialTicks, world, mc);
        }
    }

    @ScriptMethodDocumentation(args="String", usage="texture location", notes="Adds a SkyboxRenderer to the sky renderer with the provided texture location and returns it. The texture is used to generate a skybox in the standard format.")
    public SkyboxRenderer addSkybox(String singleTexture) {
        SkyboxRenderer skybox = new SkyboxRenderer(singleTexture);
        this.renderObjects.add(skybox);
        return skybox;
    }

    public SkyboxRenderer addSkybox(String topTexture, String bottomTexture, String northTexture, String southTexture, String eastTexture, String westTexture) {
        SkyboxRenderer skybox = new SkyboxRenderer(topTexture, bottomTexture, northTexture, southTexture, eastTexture, westTexture);
        this.renderObjects.add(skybox);
        return skybox;
    }

    @ScriptMethodDocumentation(usage="", notes="Adds the vanilla sun and moon to the sky renderer. Currently cannot set a custom sun/moon texture except by making it part of the skybox texture.")
    public SunRenderer addSunMoon() {
        SunRenderer sun = new SunRenderer();
        this.renderObjects.add(sun);
        return sun;
    }
}

